% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\name{AUROC.single.over.classes}
\alias{AUROC.single.over.classes}
\title{AUROC over classes}
\usage{
AUROC.single.over.classes(target, pred)
}
\arguments{
\item{target}{matrix with the target multilabels: rows correspond to examples and columns to classes. 
\eqn{target[i,j]=1} if example \eqn{i} belongs to class \eqn{j}, \eqn{target[i,j]=0} otherwise.}

\item{pred}{a numeric matrix with predicted values (scores): rows correspond to examples and columns to classes.}
}
\value{
a list with two elements:
\enumerate{
\item average: the average AUROC across classes;        
\item per.class: a named vector with AUROC for each class. Names correspond to classes
}
}
\description{
High-level function to compute the Area under the ROC Curve (AUROC) for a set of classes through \pkg{precrec} package
}
\examples{
data(labels);
data(scores);
data(graph);
root <- root.node(g);
L <- L[,-which(colnames(L)==root)];
S <- S[,-which(colnames(S)==root)];
AUC <- AUROC.single.over.classes(L,S);
}
\seealso{
\code{\link{AUROC.single.class}}
}
