% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HLAgazeteer}
\alias{HLAgazeteer}
\title{Functional and Organizational Categories of Genes Supported by the IPD-IMGT/HLA Database}
\format{
A large list of 19 vectors that define specific categories of genes supported by the IPD-IMGT/HLA Database
\itemize{
.   \item(align: all genes with alignments in the IPD/IMGT-HLA GitHub Repository)
\item(gen: genes with genomic alignments in the IPD/IMGT-HLA GitHub Repository)
\item(nuc: genes with nucleotide alignments in the IPD/IMGT-HLA GitHub Repository)
\item(prot: genes with protein alignments in the IPD/IMGT-HLA GitHub Repository)
\item(nogen: genes with no genomic alignments)
\item(nonuc: genes with no nucleotide alignments)
\item(noprot: genes with no protein alignments)
\item(pseudo: pseudogenes)
\item(frag: gene fragments)
\item(hla: HLA genes)
\item(expressed: genes that are expressed)
\item(notexpressed: genes that are not expressed)
\item(classireg: genes found in the HLA class I region)
\item(classihla: class I HLA genes)
\item(classiireg: genes found in the HLA class II region)
\item(classiihla: class II HLA genes)
\item(classical: classical HLA genes)
\item(nonclassical: non-classical HLA genes)
\item(map: all genes organized by 5' to 3' map order on the genomic reference + strand)
\item(version: IPD-IMGT/HLA Database version used to build the HLAgazeteer)
}
}
\source{
https://hla.alleles.org/genes

https://github.com/ANHIG/IMGTHLA/tree/Latest/alignments

Andersson Front. Biosci. 1998, 3(4), 739–745. https://doi.org/10.2741/a317

Alexandrov et al. HLA 2023, Vol.102(5), p.599-606. https://doi.org/10.1111/tan.15180

https://www.ncbi.nlm.nih.gov/nucleotide/NC_000009.12
}
\usage{
data(HLAgazeteer)
}
\description{
A list object of nineteen vectors that identify genes in the HLA region that share specific commonalities.
This object is built by the buildGazeteer() function.
}
\keyword{datasets}
