% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlm_augment.R
\name{hlm_augment}
\alias{hlm_augment}
\alias{hlm_augment.default}
\alias{hlm_augment.lmerMod}
\title{Calculating residuals and influence diagnostics for HLMs

\code{hlm_augment} is used to compute residuals, fitted values, and influence diagnostics for a 
hierarchical linear model. The residuals and fitted values are computed using Least Squares(LS)
and Empirical Bayes (EB) methods. The influence diagnostics are computed through one step 
approximations.}
\usage{
hlm_augment(object, ...)

\method{hlm_augment}{default}(object, ...)

\method{hlm_augment}{lmerMod}(object, level = 1, include.ls = TRUE, data = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{lmerMod} or \code{lme}.}

\item{...}{currently not used}

\item{level}{which residuals should be extracted and what cases should be deleted for influence diagnostics.
If \code{level = 1} (default), then within-group (case-level) residuals are returned and influence diagnostics
are calculated for individual observations. Otherwise, \code{level} should be the name of a grouping
factor as defined in \code{flist} for a \code{lmerMod} object or as in \code{groups} for a \code{lme} object.
This will return between-group residuals and influence diagnostics calculated for each group.}

\item{include.ls}{a logical indicating if LS residuals should be included in the
return tibble. \code{include.ls = FALSE} decreases runtime substantially.}

\item{data}{the original data frame passed to `lmer`. This is only necessary for `lmerMod` models where
`na.action = "na.exclude"`}
}
\description{
Calculating residuals and influence diagnostics for HLMs

\code{hlm_augment} is used to compute residuals, fitted values, and influence diagnostics for a 
hierarchical linear model. The residuals and fitted values are computed using Least Squares(LS)
and Empirical Bayes (EB) methods. The influence diagnostics are computed through one step 
approximations.
}
\details{
The \code{hlm_augment} function combines functionality from \code{hlm_resid}
and \code{hlm_influence} for a simpler way of obtaining residuals and influence 
diagnostics. Please see \code{?hlm_resid} and \code{?hlm_influence} for additional information 
about the returned values.
}
\note{
\code{hlm_augment} does not allow for the deletion of specific cases, the specification of other
types of leverage, or the use of full refits of the model instead of one step approximations for influence
diagnostics. If this additional functionality is desired, \code{hlm_influence} should be used instead. The additional
parameter \code{standardize} is available in \code{hlm_resid}; if this are desired, \code{hlm_resid}
should be used instead.
}
