% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shs.R
\name{shs}
\alias{shs}
\title{Spatial heterogeneity-based segmentation (SHS) for homogeneous segmentation of spatial lines data.}
\usage{
shs(var = "deflection", length = "length", data, range = NULL)
}
\arguments{
\item{var}{A character or a character vector of variable names,
such as a road pavement performance indicator.}

\item{length}{A character of road length name in data.}

\item{data}{A data frame of a dataset.}

\item{range}{A vector of segment length threshold.}
}
\description{
Spatial heterogeneity-based segmentation (SHS) for homogeneous segmentation of spatial lines data.
}
\examples{
testdata <- tsdwa[1:100,]
testdata$length <- testdata$SLK.end - testdata$SLK.start
testdata <- shs(var = "Deflection", length = "length", testdata, range = c(0.1, 0.5))

}
