% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitlong.R
\name{splitlong}
\alias{splitlong}
\title{Split long segments to segments within length threshold.}
\usage{
splitlong(var = "deflection", length = "length",
                 seg.id = "seg.id", data, range = NULL)
}
\arguments{
\item{var}{A character or a character vector of variable names,
such as a road pavement performance indicator.}

\item{length}{A character of length name.}

\item{seg.id}{A character of the name of new segment number.}

\item{data}{A data frame of a dataset.}

\item{range}{A vector of segment length threshold.}
}
\description{
Split long segments to segments within length threshold.
}
\examples{
testdata <- tsdwa[1:1000,]
testdata$length <- round(testdata$SLK.end - testdata$SLK.start, digits = 10)
testdata <- cda(var = "Deflection", length = "length", testdata, range = c(0.1, 0.5))
testdata <- splitlong(var = "Deflection", length = "length",
                      seg.id = "seg.id", testdata, range = c(0.1, 0.5))
seglength.summary <- testdata[, .(sum(length)), by = .(seg.id)]

}
