% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{htlr_predict}
\alias{htlr_predict}
\title{Make Prediction on New Data (Advanced)}
\usage{
htlr_predict(
  X_ts,
  fithtlr = NULL,
  deltas = NULL,
  burn = NULL,
  thin = NULL,
  usedmc = NULL
)
}
\arguments{
\item{X_ts}{Matrix of values at which predictions are to be made.}

\item{fithtlr}{Fitted HTLR model object.}

\item{deltas}{The values of deltas (for example true deltas) used to make prediction; 
will override \code{fithtlr} if provided.}

\item{burn, thin}{\code{burn} of Markov chain (super)iterations will be discarded for prediction,
and only every \code{thin} are used.}

\item{usedmc}{Indices of Markov chain iterations used for inference. 
If supplied, \code{burn} and \code{thin} will be ignored.}
}
\value{
A matrix of predictive probabilities, with rows for cases, cols for classes.
}
\description{
This function uses MCMC samples from fitted \code{htlrfit} object OR user supplied 
regression coefficient to predict the class labels of test cases.
}
\keyword{internal}
