/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml.driver;

import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDriver
implements XmlHandler,
Locator,
Attributes,
XMLReader {
    private DefaultHandler base = new DefaultHandler();
    private XmlParser parser;
    private boolean seenDTDEvents = false;
    private EntityResolver entityResolver = this.base;
    private DTDHandler dtdHandler = this.base;
    private ContentHandler documentHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private String elementName = null;
    private Stack entityStack = new Stack();
    private Vector attributeNames = new Vector();
    private Vector attributeValues = new Vector();
    private Hashtable properties = new Hashtable();
    private Hashtable features = new Hashtable();

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXException("AElfred driver does not yet have locale support.");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(ContentHandler contentHandler) {
        this.documentHandler = contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        try {
            if (inputSource.getCharacterStream() != null) {
                this.parser.parse(inputSource.getSystemId(), inputSource.getPublicId(), inputSource.getCharacterStream());
            } else if (inputSource.getByteStream() != null) {
                this.parser.parse(inputSource.getSystemId(), inputSource.getPublicId(), inputSource.getByteStream(), inputSource.getEncoding());
            } else {
                this.parser.parse(inputSource.getSystemId(), inputSource.getPublicId(), inputSource.getEncoding());
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        finally {
            try {
                this.closeStreams(inputSource);
            }
            catch (Exception exception) {}
        }
        try {
            this.closeStreams(inputSource);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void parse(String string) throws SAXException {
        this.parse(new InputSource(string));
    }

    private void closeStreams(InputSource inputSource) throws IOException {
        if (inputSource.getCharacterStream() != null) {
            inputSource.getCharacterStream().close();
        }
        if (inputSource.getByteStream() != null) {
            inputSource.getByteStream().close();
        }
    }

    public void startDocument() throws SAXException {
        this.documentHandler.setDocumentLocator(this);
        this.documentHandler.startDocument();
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    public void endDocument() throws SAXException {
        this.documentHandler.endDocument();
    }

    public Object resolveEntity(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.entityResolver.resolveEntity(string, string2);
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return inputSource.getByteStream();
        }
        return inputSource.getSystemId();
    }

    public void startExternalEntity(String string) throws SAXException {
        this.entityStack.push(string);
    }

    public void endExternalEntity(String string) throws SAXException {
        this.entityStack.pop();
    }

    public void doctypeDecl(String string, String string2, String string3) throws SAXException {
    }

    public void attribute(String string, String string2, boolean bl) throws SAXException {
        if (string2 != null) {
            this.attributeNames.addElement(string);
            this.attributeValues.addElement(string2);
        }
    }

    public void startElement(String string) throws SAXException {
        if (!this.seenDTDEvents) {
            this.deliverDTDEvents();
            this.seenDTDEvents = true;
        }
        this.elementName = string;
        this.documentHandler.startElement("", string, "", this);
        this.elementName = null;
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    public void endElement(String string) throws SAXException {
        this.documentHandler.endElement("", string, "");
    }

    public void charData(char[] cArray, int n, int n2) throws SAXException {
        this.documentHandler.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.documentHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.documentHandler.processingInstruction(string, string2);
    }

    public void error(String string, String string2, int n, int n2) throws SAXException {
        this.errorHandler.fatalError(new SAXParseException(string, null, string2, n, n2));
    }

    private void deliverDTDEvents() throws SAXException {
        String string;
        String string2;
        String string3;
        Enumeration enumeration = this.parser.declaredNotations();
        Enumeration enumeration2 = this.parser.declaredEntities();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = this.parser.getNotationPublicId(string3);
            string = this.parser.getNotationSystemId(string3);
            this.dtdHandler.notationDecl(string3, string2, string);
        }
        while (enumeration2.hasMoreElements()) {
            String string4 = (String)enumeration2.nextElement();
            if (this.parser.getEntityType(string4) != 2) continue;
            string2 = this.parser.getEntityPublicId(string4);
            string = this.parser.getEntitySystemId(string4);
            string3 = this.parser.getEntityNotationName(string4);
            this.dtdHandler.unparsedEntityDecl(string4, string2, string, string3);
        }
    }

    public int getLength() {
        return this.attributeNames.size();
    }

    public String getName(int n) {
        return (String)this.attributeNames.elementAt(n);
    }

    public String getType(int n) {
        switch (this.parser.getAttributeType(this.elementName, this.getName(n))) {
            case 0: 
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: 
            case 9: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 10: {
                return "NOTATION";
            }
        }
        return null;
    }

    public String getValue(int n) {
        return (String)this.attributeValues.elementAt(n);
    }

    public String getType(String string) {
        for (int i = 0; i < this.getLength(); ++i) {
            if (!string.equals(this.getName(i))) continue;
            return this.getType(i);
        }
        return null;
    }

    public String getValue(String string) {
        for (int i = 0; i < this.getLength(); ++i) {
            if (!string.equals(this.getName(i))) continue;
            return this.getValue(i);
        }
        return null;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return (String)this.entityStack.peek();
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    public boolean getFeature(String string) {
        if (this.features.containsKey(string)) {
            return (Boolean)this.features.get(string);
        }
        return false;
    }

    public void setFeature(String string, boolean bl) {
        this.features.put(string, new Boolean(bl));
    }

    public Object getProperty(String string) {
        if (this.properties.containsKey(string)) {
            return this.properties.get(string);
        }
        return null;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.documentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.documentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getURI(int n) {
        return "";
    }

    public String getLocalName(int n) {
        return "";
    }

    public String getQName(int n) {
        return "";
    }

    public int getIndex(String string, String string2) {
        return -1;
    }

    public int getIndex(String string) {
        return -1;
    }

    public String getType(String string, String string2) {
        return "";
    }

    public String getValue(String string, String string2) {
        return "";
    }
}

