% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloseq_subset.R
\name{phyloseq_subset}
\alias{phyloseq_subset}
\title{Make a list of phyloseq object subsets}
\usage{
phyloseq_subset(physeq, params, ex)
}
\arguments{
\item{physeq}{Phyloseq object}

\item{params}{data.frame of parameters supplies to \code{ex}}

\item{ex}{Expression for subsetting the phyloseq object}
}
\value{
A list of Phyloseq objects
}
\description{
Create a list of phyloseq object subsets based on phyloseq
sample data parameters (e.g., a phyloseq subset for each treatment)
}
\examples{
data(physeq_S2D2)
# making subsets by substrate and time point
params = get_treatment_params(physeq_S2D2, c('Substrate', 'Day'))
# filtering out controls
params = dplyr::filter(params, Substrate!='12C-Con')
# making expression for subsetting labeled-unlabeled gradient comparisons
ex = "(Substrate=='12C-Con' & Day=='${Day}') | (Substrate=='${Substrate}' & Day == '${Day}')"
physeq_l = phyloseq_subset(physeq_S2D2, params, ex)
physeq_l

}

