% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BD_ordinations.R
\name{phyloseq_ord_plot}
\alias{phyloseq_ord_plot}
\title{Plotting beta diversity ordination}
\usage{
phyloseq_ord_plot(physeq_ord_df, title = NULL,
  point_size = "Buoyant_density", point_fill = "Substrate",
  point_alpha = 0.5, point_shape = NULL)
}
\arguments{
\item{physeq_ord_df}{A list of data.frame objects (see phyloseq_list_ord_dfs)}

\item{title}{Plot title}

\item{point_size}{The data.frame column determining point size}

\item{point_fill}{The data.frame column determining point fill color}

\item{point_alpha}{The data.frame column (or just a single value) determining point alpha}

\item{point_shape}{The data.frame column (or just a single value) determining point shape}
}
\value{
ggplot2 object
}
\description{
For each data.frame object in a list (coverted from ordination objects),
creates a ggplot figure.
}
\examples{
data(physeq_S2D2_l)
\dontrun{
# make a list of beta diversity distance matrix objects
physeq_S2D2_l_d = physeq_list_betaDiv(physeq_S2D2_l)
# make a list of ordinations
physeq_S2D2_l_d_ord = physeq_list_ord(physeq_S2D2_l, physeq_S2D2_l_d)
# convert ordination information to data.frame objects
physeq_S2D2_l_d_ord_df = phyloseq_list_ord_dfs(physeq_S2D2_l, physeq_S2D2_l_d_ord)
# make ordination plots with ggplot2
phyloseq_ord_plot(physeq_S2D2_l_d_ord_df)
}

}
