% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC_correlation_simplify.R
\name{IC_correlation_simplify}
\alias{IC_correlation_simplify}
\title{Simplify the correlation matrix}
\usage{
IC_correlation_simplify(matrix, variable = NULL)
}
\arguments{
\item{matrix}{The correlation matrix to simplify}

\item{variable}{a vector with the name of columns to keep}
}
\value{
A list
}
\description{
This function can be used to simplify the network of correlations.\cr
If no vector of variables is given, the variables not linked to any other variable are removed. 
If a vector of variables is given, only link to these variables are retained.
\code{https://fr.wikipedia.org/wiki/Iconographie_des_corrélations}
}
\details{
IC_correlation_simplify simplifies the correlation matrix
}
\examples{
\dontrun{
library("HelpersMG")
es <- structure(list(Student = c("e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8"), 
                 Mass = c(52, 59, 55, 58, 66, 62, 63, 69), 
                 Age = c(12, 12.5, 13, 14.5, 15.5, 16, 17, 18), 
                 Assiduity = c(12, 9, 15, 5, 11, 15, 12, 9), 
                 Note = c(5, 5, 9, 5, 13.5, 18, 18, 18)), 
                 row.names = c(NA, -8L), class = "data.frame")

es

df <- IC_clean_data(es, debug = TRUE)
cor_matrix <- IC_threshold_matrix(data=df, threshold = NULL, progress=FALSE)
cor_threshold <- IC_threshold_matrix(data=df, threshold = 0.3)
par(mar=c(1,1,1,1))
set.seed(4)
plot(cor_threshold)
cor_threshold_Note <- IC_correlation_simplify(matrix=cor_threshold, variable="Note")
plot(cor_threshold_Note)
}
}
\references{
Lesty, M., 1999. Une nouvelle approche dans le choix des régresseurs de la régression multiple en présence d’interactions et de colinéarités. Revue de Modulad 22, 41-77.
}
\seealso{
Other Iconography of correlations: 
\code{\link{IC_clean_data}()},
\code{\link{IC_threshold_matrix}()},
\code{\link{plot.IconoCorel}()}
}
\author{
Marc Girondot
}
\concept{Iconography of correlations}
