% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcutter.R
\name{rcutter}
\alias{rcutter}
\title{Random values of unobserved values of cut distribution.}
\usage{
rcutter(
  cutter = stop("A result of cutter() must be provided"),
  n = 1,
  lower_detection_limit = NULL,
  upper_detection_limit = NULL,
  method_cut = c("censored", "truncated"),
  observed_detection_limit = FALSE,
  random_method = c("medianMCMC", "MCMC", "ML"),
  index_mcmc = NULL
)
}
\arguments{
\item{cutter}{The fitted model obtained with cutter()}

\item{n}{number of random numbers}

\item{lower_detection_limit}{The lower detection limit}

\item{upper_detection_limit}{The upper detection limit}

\item{method_cut}{What method is used to cut the distribution: "censored", "truncated"?}

\item{observed_detection_limit}{If TRUE, will use the pattern of detection limit as in observations}

\item{random_method}{How to get parameters; it can be "ML", "medianMCMC", or "MCMC"}

\item{index_mcmc}{For MCMC random_method, the index of data to be used.}
}
\value{
A vector with the random numbers.
}
\description{
Return n random numbers.\cr
It can be used to get the posterior predictive distribution; see example.\cr
If random_method is "ML", the parameter values obtained using maximum likelihood are used.\cr
If random_method is "medianMCMC", the parameter values obtained using median of posterior distribution are used.\cr
If random_method is "MCMC", the parameter values are one sample of the MCMC posterior distribution.\cr
if observed_detection_limit is set to TRUE, the number of random number is equal to the number of observations; n is not used.\cr
rcutter is the abbreviation for random-cutter.
}
\details{
rcutter returns random values based on fitted distribution with cut.
}
\examples{
\dontrun{
library(HelpersMG)
# _______________________________________________________________
# right censored distribution with gamma distribution
# _______________________________________________________________
# Detection limit
DL <- 100
# Generate 100 random data from a gamma distribution
obc <- rgamma(100, scale=20, shape=2)
# remove the data below the detection limit
obc[obc>DL] <- +Inf
# search for the parameters the best fit these censored data
result <- cutter(observations=obc, upper_detection_limit=DL, 
                           cut_method="censored")
result
# Posterior predictive distribution
r <- rcutter(cutter=result, upper_detection_limit=DL, n=100)
hist(r)
# _______________________________________________________________
# left censored distribution with gamma distribution
# _______________________________________________________________
# Detection limit
DL <- 10
# Generate 100 random data from a gamma distribution
obc <- rgamma(100, scale=20, shape=2)
# remove the data below the detection limit
obc[obc<DL] <- -Inf
# search for the parameters the best fit these truncated data
result <- cutter(observations=obc, lower_detection_limit=DL, 
                          cut_method="censored")
result
plot(result, breaks=seq(from=0, to=200, by=10))
r <- rcutter(cutter=result, n=100)
hist(r, breaks=seq(from=0, to=200, by=10))
r <- rcutter(cutter=result, lower_detection_limit=DL, n=100)
hist(r, breaks=seq(from=0, to=250, by=10))
# With censored method, some values are replaced with +Inf or -Inf
any(is.infinite(r))
r <- rcutter(cutter=result, upper_detection_limit=DL, n=100, 
             method_cut="truncated")
# With truncated method, the values below LDL or upper UDL are not present
any(is.infinite(r))
hist(r, breaks=seq(from=0, to=10, by=0.25))
r <- rcutter(cutter=result, observed_detection_limit=TRUE)
hist(r, breaks=seq(from=0, to=300, by=10))
}
}
\seealso{
Other Distributions: 
\code{\link{cutter}()},
\code{\link{dbeta_new}()},
\code{\link{dcutter}()},
\code{\link{dggamma}()},
\code{\link{logLik.cutter}()},
\code{\link{plot.cutter}()},
\code{\link{print.cutter}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Distributions}
