% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kohonen_maps.R
\name{WH_2d_Kohonen_maps}
\alias{WH_2d_Kohonen_maps}
\title{Batch Kohonen self-organizing 2d maps for  histogram-valued data}
\usage{
WH_2d_Kohonen_maps(x, net = list(xdim = 4, ydim = 3, topo = c("rectangular")),
  kern.param = 2, TMAX = 2, Tmin = 0.2, niter = 30, repetitions = 5,
  simplify = FALSE, qua = 10, standardize = FALSE)
}
\arguments{
\item{x}{A MatH object (a matrix of distributionH).}

\item{net}{a list describing the topology of the net \code{list(xdim=number of rows,
ydim=numbers of columns,topo=c('rectangular' or 'hexagonal'))}, see \code{somgrid} sintax in package\pkg{class} 
default \code{net=list(xdim=4,ydim=3,topo=c('rectangular'))}}

\item{kern.param}{(default =2) the kernel parameter for the RBF kernel used in the algorithm}

\item{TMAX}{a parameter useful for the iterations (default=2)}

\item{Tmin}{a parameter useful for the iterations (default=0.2)}

\item{niter}{maximum number of iterations (default=30)}

\item{repetitions}{number of repetion of the algorithm (default=5), beacuase each launch may generate a local optimum}

\item{simplify}{a logical parameter for speeding up computations (default=FALSE). If true data are recoded in order to have fast computations}

\item{qua}{if \code{simplify=TRUE} number of equally spaced quantiles for recodify the histograms (default=10)}

\item{standardize}{A logic value (default is FALSE). If TRUE, histogram-valued data are standardized,  variable by variable, 
using the Wassertein based standard deviation. Use if one wants to have variables with std equal to one.}
}
\value{
a list with the results of the Batch Kohonen map
}
\description{
The function implements a Batch Kohonen self-organizing 2d maps algorithm for  histogram-valued data.
}
\details{
An extension of Batch Self Organised Map (BSOM) is here proposed for  histogram data.
 These kind of data have been defined in the context of symbolic data analysis.
  The BSOM cost function is then based on a distance 
  function: the L2 Wasserstein distance. This distance has been widely proposed in several
   techniques of analysis (clustering, regression) when input data are expressed by distributions 
   (empirical by histograms or theoretical by probability distributions).
   The peculiarity of such distance is to be an Euclidean distance between quantile functions so 
   that all the properties proved for L2 distances are verified again. An adaptative versions of 
   BSOM is also introduced considering an automatic system of weights in the cost function in 
   order to take into account the different effect of the several variables in the Self-Organised Map 
   grid.
}
\section{Slots}{

\describe{
\item{\code{solution}}{A list.Returns the best solution among the \code{repetitions}etitions, i.e. 
the one having the minimum sum of squares criterion.}

\item{\code{solution$MAP}}{The map topology.}

\item{\code{solution$IDX}}{A vector. The clusters at which the objects are assigned.}

\item{\code{solution$cardinality}}{A vector. The cardinality of each final cluster.}

\item{\code{solution$proto}}{A \code{MatH} object with the description of centers.}

\item{\code{solution$Crit}}{A number. The criterion (Sum od square deviation 
from the centers) value at the end of the run.}

\item{\code{quality}}{A number. The percentage of Sum of square deviation explained by the model. 
(The higher the better)}
}}
\examples{
\dontrun{
results=WH_2d_Kohonen_maps(x = BLOOD,k = 2,
                                   net=list(xdim=2,ydim=3,topo=c('rectangular')), 
                                   repetitions = 2,simplify = TRUE,
                                   qua = 10,standardize = TRUE)
                                   }
}
\references{
Irpino A, Verde R, De Carvalho FAT (2012). Batch self organizing maps for interval and histogram data.
In: Proceedings of COMPSTAT 2012. p. 143-154, ISI/IASC, ISBN: 978-90-73592-32-2
}

