% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HospiNet.R
\docType{class}
\name{HospiNet}
\alias{HospiNet}
\title{Class providing the HospiNet object with its methods}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for accessing facility networks.
}
\description{
Class providing the HospiNet object with its methods

Class providing the HospiNet object with its methods
}
\section{Methods}{

\describe{
  \item{\code{new(edgelist,
window_threshold,
nmoves_threshold,
noloops)}}{This method is used to create an object of this class with \code{edgelist} as the necessary information to create the network.
The other arguments \code{window_threshold}, \code{nmoves_threshold}, and \code{noloops} are specific to the \code{edgelist} and need to be provided.
For ease of use, it is preferable to use the function \code{\link{hospinet_from_subject_database}}}
  \item{\code{print()}}{This method prints basic information about the object.}
  \item{\code{plot(type = "matrix")}}{This method plots the network matrix by default.
  The argument \code{type} can take the following values:
  \describe{
  \item{matrix}{plot the network matrix,}
  \item{clustered_matrix}{identify and plot cluster(s) in the matrix using the infomap algorithm (from igraph),}
  \item{degree}{plot the histogram of the number of neighbors by facility,}
  \item{circular_network}{plot the network by clusters using a "spaghetti-like" layout. Only works when there are at least 2 clusters.}
  }
  }
}
}

\examples{
mydbsmall <- create_fake_subjectDB(n_subjects = 100, n_facilities = 10)

hn <- hospinet_from_subject_database(
  base = checkBase(mydbsmall),
  window_threshold = 10,
  count_option = "successive",
  condition = "dates"
)

hn

plot(hn)
plot(hn, type = "clustered_matrix")
}
\keyword{data}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{edgelist}}{(data.table) the list of edges (origin, target) and their associated number of movements (N) (read-only)}

\item{\code{edgelist_long}}{(data.table) edgelist with additional information (read-only)}

\item{\code{matrix}}{(matrix) the transfer matrix (active binding, read-only)}

\item{\code{igraph}}{(igraph) the igraph object corresponding to the network (active binding, read-only)}

\item{\code{n_facilities}}{the number of facilities in the network (read-only)}

\item{\code{n_movements}}{the total number of subject movements in the network (read-only)}

\item{\code{window_threshold}}{the window threshold used to compute the network (read-only)}

\item{\code{nmoves_threshold}}{the nmoves threshold used to compute the network (read-only)}

\item{\code{noloops}}{TRUE if loops have been removed (read-only)}

\item{\code{hist_degrees}}{histogram data of the number of connections per facility}

\item{\code{LOSPerHosp}}{the mean length of stay for each facility (read-only)}

\item{\code{admissionsPerHosp}}{the number of admissions to each facility (read-only)}

\item{\code{subjectsPerHosp}}{the number of unique subjects admitted to each facility (read-only)}

\item{\code{degrees}}{number of connections for each facilities (total, in, and out)(read-only)}

\item{\code{closenesss}}{the closeness centrality of each facility (read-only)}

\item{\code{betweennesss}}{the betweenness centrality of each facility (read-only)}

\item{\code{cluster_infomap}}{the assigned community for each facility, based on the infomap algorithm (read-only)}

\item{\code{cluster_fast_greedy}}{the assigned community for each facility, based on the greedy modularity optimization algorithm (read-only)}

\item{\code{hubs_global}}{Kleinberg's hub centrality scores, based on the entire network (read-only)}

\item{\code{hubs_infomap}}{same as hubs_global, but computed per community based on the infomap algorithm (read-only)}

\item{\code{hubs_fast_greedy}}{same as hubs_global, but computed per community based on the infomap algorithm (read-only)}

\item{\code{metricsTable}}{(data.table) all of the above metrics for each facility (read-only)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HospiNet-new}{\code{HospiNet$new()}}
\item \href{#method-HospiNet-print}{\code{HospiNet$print()}}
\item \href{#method-HospiNet-plot}{\code{HospiNet$plot()}}
\item \href{#method-HospiNet-clone}{\code{HospiNet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HospiNet-new"></a>}}
\if{latex}{\out{\hypertarget{method-HospiNet-new}{}}}
\subsection{Method \code{new()}}{
Create a new HospiNet object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HospiNet$new(
  edgelist,
  edgelist_long,
  window_threshold,
  nmoves_threshold,
  noloops,
  prob_params,
  fsummary = NULL,
  create_MetricsTable = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{edgelist}}{Short format edgelist}

\item{\code{edgelist_long}}{Long format edgelist}

\item{\code{window_threshold}}{The window threshold used to compute the network}

\item{\code{nmoves_threshold}}{The nmoves threshold used to compute the network}

\item{\code{noloops}}{TRUE if loops have been removed}

\item{\code{prob_params}}{Currently unused}

\item{\code{fsummary}}{A pre-built data.table with the LOSPerHosp, subjectsPerHosp
and admissionsPerHosp that don't need to be recomputed.}

\item{\code{create_MetricsTable}}{all of the metrics for each facility}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `HospiNet` object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HospiNet-print"></a>}}
\if{latex}{\out{\hypertarget{method-HospiNet-print}{}}}
\subsection{Method \code{print()}}{
Prints a basic description of the number of facilities and movements of
a HospiNet object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HospiNet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HospiNet-plot"></a>}}
\if{latex}{\out{\hypertarget{method-HospiNet-plot}{}}}
\subsection{Method \code{plot()}}{
Plots various representations of the HospiNet network
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HospiNet$plot(type = "matrix", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{One of "matrix", "degree", "clustered_matrix", "circular network"
Choose what you would like to plot - the connectivity matrix, degree
distribution, the clusters, or the network in a circle.}

\item{\code{...}}{Additional arguments to be provided. Only supported for `type == 'circular_network`'.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a `ggplot2` object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HospiNet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HospiNet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HospiNet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
