% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{GOF_rmse}
\alias{GOF_rmse}
\title{Calculate root-mean-square error with options to normalize}
\usage{
GOF_rmse(
  mod,
  obs,
  normalize = c("none", "mean", "range", "stdev", "iqr", "iqr-1", "iqr-2", "iqr-3",
    "iqr-4", "iqr-5", "iqr-6", "iqr-7", "iqr-8", "iqr-9", NULL),
  na.rm = TRUE
)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{normalize}{'character' value. Option to normalize the root-mean-square error (NRMSE) by
several normalizing options. Default is \code{'none'}(no normalizing). RMSE is
returned.\cr
\code{'mean'}. RMSE is normalized by the mean of \code{obs}.\cr
\code{'range'}. RMSE is normalized by the range \code{(max - min)} of \code{obs}.\cr
\code{'stdev'}. RMSE is normalized by the standard deviation of \code{obs}.\cr
\code{'iqr-#'}. RMSE is normalized by the inter-quartile range of \code{obs}, with distribution type
(see \code{\link[stats:quantile]{stats::quantile}} function) indicated by integer number (for example \code{"iqr-8"}).
If no type specified, default type is \code{iqr-7}, the quantile function default.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}.}
}
\value{
'numeric' value of computed root-mean-square error (RMSE) or
normalized root-mean-square error (NRMSE)
}
\description{
Calculate root-mean-square error (RMSE) between modeled (simulated) and observed
values. Error is defined as modeled minus observed.
}
\examples{
# RMSE
GOF_rmse(mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs)
# NRMSE
GOF_rmse(
  mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs, normalize = 'stdev'
)

}
\keyword{goodness-of-fit}
