% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{StrelkaSBSVCFFilesToCatalogAndPlotToPdf}
\alias{StrelkaSBSVCFFilesToCatalogAndPlotToPdf}
\title{Create SBS and DBS catalogs from Strelka SBS VCF files and plot them to PDF}
\usage{
StrelkaSBSVCFFilesToCatalogAndPlotToPdf(files, ref.genome,
  trans.ranges = NULL, region = "unknown", output.file)
}
\arguments{
\item{files}{Character vector of file paths to the Strelka SBS VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{a \code{\link[data.table]{data.table}} which contains
transcript range and strand information. Please refer to
\code{\link{TranscriptRanges}} for more details.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{output.file}{The name of the PDF file to be produced.}
}
\value{
A list of 3 SBS catalogs (one each for 96, 192, and 1536), 3 DBS
  catalogs (one each for 78, 136, and 144) and their graphs plotted to PDF
  with specified file name. If trans.ranges = NULL, SBS 192 and DBS 144
  catalog will not be generated and plotted. Each catalog has attributes
  added. See \code{\link{as.catalog}} for more details.
}
\description{
Create 3 SBS catalogs (96, 192, 1536) and 3 DBS catalogs (78, 136, 144) from the
Strelka SBS VCFs specified by \code{files} and plot them to PDF
}
\details{
This function calls \code{\link{StrelkaSBSVCFFilesToCatalog}} and
\code{\link{PlotCatalogToPdf}}
}
\note{
SBS 192 and DBS 144 catalogs include only mutations in transcribed regions.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.SBS.GRCh37.vcf",
                      package = "ICAMS"))
catalogs <- 
  StrelkaSBSVCFFilesToCatalogAndPlotToPdf(file, ref.genome = "hg19",
                                          trans.ranges = trans.ranges.GRCh37,
                                          region = "genome",
                                          output.file = file.path(tempdir(), 
                                                                  "StrelkaSBS.pdf")) 
}
