% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadVCFs}
\alias{ReadVCFs}
\title{Read VCF files}
\usage{
ReadVCFs(
  files,
  variant.caller = NULL,
  names.of.VCFs = NULL,
  tumor.col.names = NA
)
}
\arguments{
\item{files}{Character vector of file paths to the VCF files.}

\item{variant.caller}{Name of the variant caller that produces \strong{all}
the VCFs specified by \code{files}, can be either \code{strelka},
\code{mutect} or \code{freebayes}. This information is needed to calculate
the VAFs (variant allele frequencies). If \code{NULL}(default), then VAF and
read depth information will not be added to the original VCFs.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order
of names in \code{names.of.VCFs} should match the order of VCF file paths
in \code{files}. If \code{NULL}(default), this function will remove all of
the path up to and including the last path separator (if any) and file
paths without extensions (and the leading dot) will be used as the names of
the VCF files.}

\item{tumor.col.names}{Optional. Only applicable to \strong{Mutect} VCFs.
Character vector of column names in \strong{Mutect} VCFs which contain the
tumor sample information. The order of names in \code{tumor.col.names}
should match the order of \strong{Mutect} VCFs specified in \code{files}.
If \code{tumor.col.names} is equal to \code{NA}(default), this function
will use the 10th column in all the \strong{Mutect} VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}
}
\value{
A list of data frames storing data lines of the VCF files with two
  additional columns added which contain the VAF(variant allele frequency)
  and read depth information.
}
\description{
Read VCF files
}
\keyword{internal}
