% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{StandardChromNameNew}
\alias{StandardChromNameNew}
\title{Standardize the chromosome name annotations for a data frame.}
\usage{
StandardChromNameNew(df, name.of.VCF = NULL)
}
\arguments{
\item{df}{A data frame whose first column contains the Chromosome name}

\item{name.of.VCF}{Name of the VCF file.}
}
\value{
A \strong{list} with the elements
\itemize{
\item \code{df} a data frame with variants that had "legal" chromosome
names (see below for illegal chromosome names).
Leading "chr" strings are removed.
\item \code{discarded.variants}: \strong{Non-NULL only if} there
variants with illegal chromosome names; these are
names that contain the strings "GL", "Hs", "KI", "M", "random".
}
}
\description{
Standardize the chromosome name annotations for a data frame.
}
\keyword{internal}
