% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-UserMinimaxFunctions.R
\name{plot.minimax}
\alias{plot.minimax}
\title{Plotting \code{minimax} Objects}
\usage{
\method{plot}{minimax}(x, iter = NULL, sensitivity = TRUE,
  calculate_criterion = FALSE, sens.minimax.control = list(),
  crt.minimax.control = list(), silent = FALSE, plot_3d = c("lattice",
  "rgl"), evolution = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{minimax}.}

\item{iter}{Iteration number. if \code{NULL}, will be set to last iteration.}

\item{sensitivity}{Logical. If \code{TRUE}, the general equivalence theorem is used to check the optimality if the best design in iteration number \code{iter} and the sensitivity plot will be plotted.}

\item{calculate_criterion}{Re-calculate the criterion value? It only assumes a continuous parameter space for the minimax and standardized maximin designs.  Defaults to \code{FALSE}. See 'Details'.}

\item{sens.minimax.control}{Control parameters to verify general equivalence theorem. For details, see \code{\link{sens.minimax.control}}.}

\item{crt.minimax.control}{Control parameters to optimize the minimax or standardized maximin criterion at a given design over a \strong{continuous} parameter space.
For details, see \code{\link{crt.minimax.control}}.}

\item{silent}{Do not print anything? Defaults to \code{FALSE}.}

\item{plot_3d}{Which package should be used to plot the sensitivity function for two-dimensional design space. Defaults to \code{plot_3d = "lattice"}.
Only applicable when \code{sensitivity = TRUE}.}

\item{evolution}{Plot Evolution? Defaults to \code{FALSE}.}

\item{...}{Argument with no further use.}
}
\description{
This function plots the evolution of the algorithm till iteration number \code{iter} iteration and re-checks the general equivalence theorem by plotting the sensitivity function and calculating the ELB.
}
\details{
The criterion value can also be re-calculated for the output designs using new set of tuning parameters in the function \code{\link{crt.minimax.control}}.
 This is useful for  minimax and standardized maximin optimal designs to assess the robustness of the
 criterion value with respect to different values of the tuning parameters.
 To put it simple, for these designs, the user can re-calculate the
 criterion value (finds the global maximum over the parameter space given an output design in a minimax problem) with larger values for  \code{maxeval} in \code{\link{crt.minimax.control}}
 to be sure that the function \code{nloptr} finds global optima of the inner
 optimization problem (over the parameter space) using the default value
 (or a new user-given value, in case it has been reset) of \code{maxeval}.
 If increasing the value of \code{maxeval} gives different criterion values,
 then the results can not be trusted and should be repeated with a higher value for \code{maxeval}.
}
\seealso{
\code{\link{minimax}}, \code{\link{locally}}, \code{\link{robust}}
}
