% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{IDF.plot}
\alias{IDF.plot}
\title{Plotting IDF curves}
\usage{
IDF.plot(pars, probs = c(0.5, 0.9, 0.99), dur = c(0.5, 1, 2, 3, 6, 12, 24,
  48, 72, 96), cols = c(rgb(1, 0, 0, 1), rgb(0, 1, 0, 1), rgb(0, 0, 1, 1)),
  st.name = "Berlin-Dahlem", dt.name = "obs", ints = NA, ds = NA)
}
\arguments{
\item{pars}{a vector of IDF model parameters mu,sigma,xi,eta,theta}

\item{probs}{a vector of probabilities for which the IDF curves are calculated}

\item{dur}{a vector of durations at which the IDF curves are calculated}

\item{cols}{a vector of colors for the seperate IDF curves, needs same length as \code{probs}}

\item{st.name}{\code{character} overall naming of the IDF plot, e.g. name of location or model name}

\item{dt.name}{\code{character} naming the data points, e.g. obs or model name}

\item{ints}{\code{vector} of observational intensities (surted by durations)}

\item{ds}{\code{vector} of durations (same length as intensities)}
}
\description{
The function \code{IDF.plot} plots a set of IDF curves with given IDF model parameters \code{pars} for
several probability levels \code{probs} at given durations \code{dur}. The colors of the curves can be defined with
parameter \code{cols} (need to have same length as \code{probs}). The \code{station.name} will be printed in the legend.
}
\examples{
RR <- rgamma(10*30*24,shape=1)
year <- sort(rep(1:(10),30*24))
data <- data.frame(RR,year)
fit <- IDF.fit(data)
param <- fit$par
IDF.plot(pars=param,st.name="example",dt.name="rgamma")
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

