% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{fit.fun}
\alias{fit.fun}
\title{Fitting function to optimize IDF model parameters}
\usage{
fit.fun(obs, dur, mu = 1, sigma = 1, xi = 0.5, theta = 1, eta = 1,
  use.log = F, DEBUG = F, method = "Nelder-Mead", upper = Inf,
  lower = -Inf)
}
\arguments{
\item{obs}{vector of yearly intensity maxima at different durations. Order: Y1D1, Y2D1,...,YnD1,Y1D2,...YnD2,Y1D3,...,YnDk}

\item{dur}{vector of durations with same length as \code{obs}. Order: n x D1, n x D2, ... n x Dk}

\item{mu}{location value}

\item{sigma}{scale value}

\item{xi}{shape value}

\item{theta}{value defining the curvature of the IDF}

\item{eta}{value defining the slope of the IDF}

\item{use.log}{\code{logical} value for usage of logarithmic values, default is \code{FALSE}}

\item{DEBUG}{\code{logical} value for usage of debugging, if \code{TRUE} the input parameters and the value of negative
log-likelihood are printed on console for each iteration during optimization.}

\item{method}{\code{character} defining the method to be used in \code{optim}, preferences are: "Nelder-Mead", "BFGS", "L-BFGS-B"e}

\item{upper}{\code{vector} specifying the upper boundary of parameters for "L-BFGS-B" method}

\item{lower}{\code{vector} specifying the lower boundary of parameters for "L-BFGS-B" method}
}
\value{
$min value of negative log-likelihood at optimization minimum

$par vector of IDF parameters at optimization minimum
}
\description{
The function \code{fit.fun} fits IDF model parameters \code{mu,sigma,xi,theta,eta} to a set of given observations \code{obs}, 
typically a series of yearly maxima at different durations \code{d}. Options for using logarithmic parameter values and debugging
are given. Also the \code{optim} parameters \code{method} and \code{upper,lower} can be defined.
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

