\name{peak2list}
\alias{peak2list}
\title{
Peak to List (The main function)
}
\description{
This function returns a list of two data objects needed for the mass spectrometry data processing.
}
\usage{
peak2list(path = getwd(), MSfile = "")
}
\arguments{
  \item{path}{
address of the mass spectrometry file
}
  \item{MSfile}{
name of the mass spectrometry file with .mzML or .mzXML extensions
}
}
\details{
\url{https://ipa.idsl.me/mxp}
}
\value{
  \item{peakTable}{
a dataframe of different scan properties including `seqNum`, `msLevel`, `polarity`, `peaksCount`, `totIonCurrent`, `retentionTime`, `basePeakMZ`, `basePeakIntensity`, `collisionEnergy`, `lowMZ`, `highMZ`, `precursorScanNum`, `precursorMZ`, `precursorCharge`, `precursorIntensity`, `injectionTime`, `filterString`, `scanType`, `centroided`, `isolationWindowTargetMZ`, `isolationWindowLowerOffset`, `isolationWindowUpperOffset`, `scanWindowLowerLimit`, and `scanWindowUpperLimit`. `scanType` is only provided for the mzXML data format.
}
  \item{spectraList}{
a list of matrices of m/z and intensity values for each chromatogram scan
}
}
\seealso{
\url{https://colab.research.google.com/drive/1gXwwuI1zzDHykKfodLSQQt5rwTuFEMpD}
}
\examples{
temp_wd <- tempdir()
temp_wd_zip <- paste0(temp_wd,"/testfiles.zip")
download.file(
  "https://github.com/idslme/IDSL.IPA/raw/main/idsl_ipa_test_files.zip",
  destfile = temp_wd_zip)
unzip(temp_wd_zip, exdir = temp_wd)
p2l <- peak2list(path = temp_wd, MSfile = "003.mzML")
}