% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetOffsets.R
\name{subsetOffsets}
\alias{subsetOffsets}
\title{IFC_offset Subsetting}
\usage{
subsetOffsets(offsets, objects, image_type = c("img", "msk"))
}
\arguments{
\item{offsets}{object of class `IFC_offset` to subset.}

\item{objects}{integer vector, IDEAS objects ids numbers to extract.}

\item{image_type}{image_type of desired offsets. Default is c("img", "msk"). Allowed are "img" and/or "msk".}
}
\value{
a class `IFC_offset` integer vector or empty list if objects are outside of offsets.
}
\description{
Subsets `IFC_offset`
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a cif file
  file_cif <- system.file("extdata", "example.cif", package = "IFCdata")
  ## extract offsets
  offsets <- getOffsets(fileName = file_cif)
  ## subset offsets of the 4 first "img" objects
  sub_offs <- subsetOffsets(offsets = offsets, objects = 0:3, image_type = "img")
  ## show subsetted offsets' structure
  str(sub_offs)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
