% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractFromXIF.R
\name{ExtractFromXIF}
\alias{ExtractFromXIF}
\title{RIF/CIF File Reader}
\source{
For pnt_in_poly_algorithm, Trigonometry, is an adaptation of Jeremy VanDerWal's code \url{http://github.com/jjvanderwal/SDMTools}
}
\usage{
ExtractFromXIF(
  fileName,
  extract_features = TRUE,
  extract_images = FALSE,
  extract_offsets = FALSE,
  extract_stats = TRUE,
  pnt_in_poly_algorithm = 1,
  pnt_in_poly_epsilon = 1e-12,
  force_default = TRUE,
  verbose = FALSE,
  verbosity = 1,
  display_progress = TRUE,
  fast = TRUE,
  recursive = FALSE,
  ...
)
}
\arguments{
\item{fileName}{path to file.}

\item{extract_features}{whether to extract features from file. Default is TRUE.\cr
If TRUE, \code{\link{ExtractFromXIF}} will try to export features. It it fails a message will be sent.\cr
Otherwise, graphs, pops and regions will be also extracted.}

\item{extract_images}{whether to extract images information from file. Default is FALSE.}

\item{extract_offsets}{whether to extract IFDs offsets from corresponding. Default is FALSE.\cr
See \code{\link{getOffsets}} for further details.}

\item{extract_stats}{whether to extract population statistics. Default is TRUE.}

\item{pnt_in_poly_algorithm}{algorithm used to determine if object belongs to a polygon region or not. Default is 1.\cr
Note that for the moment only 1(Trigonometry) is available.}

\item{pnt_in_poly_epsilon}{epsilon to determine if object belongs to a polygon region or not. It only applies when algorithm is 1. Default is 1e-12.}

\item{force_default}{when display information can't be retrieved whether to use default values. Default is TRUE.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{verbosity}{quantity of information displayed when verbose is TRUE; 1: normal, 2: rich. Default is 1.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{fast}{whether to fast 'extract_offsets' or not. Default is TRUE.\cr
Meaning that offsets will be extracting expecting that raw object are stored in ascending order.
if extract_images is FALSE, a message will be thrown since extraction method does not ensure correct mapping between objects and offsets.\cr
if extract_images is TRUE, a warning will be sent if an object is found at an unexpected order.}

\item{recursive}{whether to recursively apply \code{\link{ExtractFromXIF}} on files defining input fileName when it is a merged. Default is FALSE.}

\item{...}{Other arguments to be passed.}
}
\value{
A named list of class `IFC_data`, whose members are:\cr
-description, a list of descriptive information,\cr
-fileName, path of fileName input,\cr
-fileName_image, same as fileName,\cr
-features, a data.frame of features,\cr
-features_def, a describing how features are defined,\cr
-graphs, a list of graphical elements found,\cr
-pops, a list describing populations found,\cr
-regions, a list describing how regions are defined,\cr
-images, a data.frame describing information about images,\cr
-offsets, an integer vector of images and masks IFDs offsets,\cr
-stats, a data.frame describing populations count and percentage to parent and total population,\cr
-checksum, current file checksum.\cr
If fileName is a merged of several files returned object will be of class `IFC_data` and `Merged`.
If recursive is set to "TRUE", ExtractFromXIF will be applied recursively on files defining the merged.
and the returned object will be a list of the above-mentionned list for each of these files.
}
\description{
Extracts data from RIF or CIF Files.
}
\details{
If extract_stats is TRUE, extract_features will be automatically forced to TRUE.\cr
If extract_images is TRUE, extract_offsets will be automatically forced to TRUE.\cr
If extract_offsets is TRUE, offsets of images and masks IFDs will be extracted.\cr
If extract_images is TRUE, information about images will be extracted.\cr
If the input fileName is a merged of several files and recursive is set to TRUE, then ExtractFromXIF will be applied recursively on these files.\cr
/!\ Note that features extraction is mandatory to correctly extract graphs, pops, regions and statistics values.\cr
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a cif file, but you can also read rif
  file_cif <- system.file("extdata", "example.cif", package = "IFCdata")
  cif <- ExtractFromXIF(fileName = file_cif)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
