% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whoami.R
\name{whoami}
\alias{whoami}
\title{Input Identification}
\usage{
whoami(
  entries = as.list(match.call()),
  search = list(info = "IFC_info", param = "IFC_param", offsets = "IFC_offset"),
  reinit = TRUE
)
}
\arguments{
\item{entries}{arguments from the function \code{\link{whoami}} is called.
/!\ \code{\link{whoami}} MUST be called explicitly this way: whoami(entries = as.list(match.call())).}

\item{search}{a non duplicated named list of classes to search for entries.}

\item{reinit}{whether to reinitialize arguments to their default values in called environment. Default is TRUE.}
}
\value{
a list whose members are 'fileName': value of fileName if provided as a named argument 
in entries and all classes defined in 'search'
}
\description{
Helper that identifies input arguments thanks to their IFC classes even if they are not or mis named.
}
\details{
if two argument of the same 'search' class are found an error will be thrown.
'fileName' will be searched every time.\cr
-at first, as an argument (named or not) of the class designated in 'search' to be the "fileName",\cr
-otherwise, as an argument (named or not) of class `fileName`,\cr
-otherwise, as a named argument of name "fileName" that was not found using 'search',\cr
-and finally, if still not found as the first not named argument not found in 'search' of type string.
}
\keyword{internal}
