################################################################################
# This file is released under the GNU General Public License, Version 3, GPL-3 #
# Copyright (C) 2020 Yohann Demont                                             #
#                                                                              #
# It is part of IFC package, please cite:                                      #
# -IFC: An R Package for Imaging Flow Cytometry                                #
# -YEAR: 2020                                                                  #
# -COPYRIGHT HOLDERS: Yohann Demont, Gautier Stoll, Guido Kroemer,             #
#                     Jean-Pierre Marolleau, Loïc Garçon,                      #
#                     INSERM, UPD, CHU Amiens                                  #
#                                                                              #
# DISCLAIMER:                                                                  #
# -You are using this package on your own risk!                                #
# -We do not guarantee privacy nor confidentiality.                            #
# -This program is distributed in the hope that it will be useful, but WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        #
# FITNESS FOR A PARTICULAR PURPOSE. In no event shall the copyright holders or #
# contributors be liable for any direct, indirect, incidental, special,        #
# exemplary, or consequential damages (including, but not limited to,          #
# procurement of substitute goods or services; loss of use, data, or profits;  #
# or business interruption) however caused and on any theory of liability,     #
# whether in contract, strict liability, or tort (including negligence or      #
# otherwise) arising in any way out of the use of this software, even if       #
# advised of the possibility of such damage.                                   #
#                                                                              #
# You should have received a copy of the GNU General Public License            #
# along with IFC. If not, see <http://www.gnu.org/licenses/>.                  #
################################################################################

#' @title Text to Image Conversion
#' @description
#' Converts string to matrix of 0 and 1.
#' @param text a character string.
#' @details at symbol @@ is a special character used for scale
#' @keywords internal
texttomatrix <- function(text) {
  text = na.omit(as.character(text)); assert(text, len = 1, typ = "character")
  text = strsplit(text, split ="|")[[1]]
  return(cbind(rbind(0,do.call(what="cbind", args=lapply(text, FUN=function(x) {
    cbind(rbind(0,0,0,0,0,0,0),
          switch(EXPR = x,
                 "1"=matrix(data = c(0,0,1,
                                     0,1,1,
                                     1,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1),nrow = 7, byrow = TRUE),
                 "2"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     0,0,0,0,1,
                                     0,0,0,1,0,
                                     0,0,1,0,0,
                                     0,1,0,0,0,
                                     1,1,1,1,1), nrow = 7, byrow = TRUE),
                 "3"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     0,0,0,0,1,
                                     0,0,0,1,0,
                                     0,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "4"=matrix(data = c(0,0,0,1,0,
                                     0,0,1,1,0,
                                     0,1,0,1,0,
                                     1,0,0,1,0,
                                     1,1,1,1,1,
                                     0,0,0,1,0,
                                     0,0,0,1,0), nrow = 7, byrow = TRUE),
                 "5"=matrix(data = c(1,1,1,1,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,1,1,1,0,
                                     0,0,0,0,1,
                                     0,0,0,0,1,
                                     1,1,1,1,0), nrow = 7, byrow = TRUE),
                 "6"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,0,
                                     1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "7"=matrix(data = c(1,1,1,1,1,
                                     0,0,0,0,1,
                                     0,0,0,0,1,
                                     0,0,0,1,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 "8"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "9"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,1,
                                     0,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "0"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "A"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "B"=matrix(data = c(1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,0), nrow = 7, byrow = TRUE),
                 "C"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "D"=matrix(data = c(1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,0), nrow = 7, byrow = TRUE),
                 "E"=matrix(data = c(1,1,1,1,1,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,1,1,1,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,1,1,1,1), nrow = 7, byrow = TRUE),
                 "F"=matrix(data = c(1,1,1,1,1,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,1,1,1,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0), nrow = 7, byrow = TRUE),
                 "G"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,1,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "H"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "I"=matrix(data = c(1,1,1,1,1,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     1,1,1,1,1), nrow = 7, byrow = TRUE),
                 "J"=matrix(data = c(0,0,0,0,1,
                                     0,0,0,0,1,
                                     0,0,0,0,1,
                                     0,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "K"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,1,0,
                                     1,0,1,0,0,
                                     1,1,0,0,0,
                                     1,0,1,0,0,
                                     1,0,0,1,0,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "L"=matrix(data = c(1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0,
                                     1,1,1,1,1), nrow = 7, byrow = TRUE),
                 "M"=matrix(data = c(1,0,0,0,1,
                                     1,1,0,1,1,
                                     1,0,1,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "N"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,0,0,1,
                                     1,0,1,0,1,
                                     1,0,0,1,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "O"=matrix(data = c(1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "P"=matrix(data = c(1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,0,
                                     1,0,0,0,0,
                                     1,0,0,0,0), nrow = 7, byrow = TRUE),
                 "Q"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,1,0,1,
                                     1,0,0,1,1,
                                     0,1,1,1,1), nrow = 7, byrow = TRUE),
                 "R"=matrix(data = c(1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "S"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,0,
                                     0,1,1,1,0,
                                     0,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "T"=matrix(data = c(1,1,1,1,1,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 "U"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,1,1,0), nrow = 7, byrow = TRUE),
                 "V"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,0,1,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 "W"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,1,0,1,
                                     1,1,0,1,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "X"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,0,1,0,
                                     0,0,1,0,0,
                                     0,1,0,1,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1), nrow = 7, byrow = TRUE),
                 "Y"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,0,1,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 "Z"=matrix(data = c(1,1,1,1,1,
                                     0,0,0,0,1,
                                     0,0,0,1,0,
                                     0,0,1,0,0,
                                     0,1,0,0,0,
                                     1,0,0,0,0,
                                     1,1,1,1,1), nrow = 7, byrow = TRUE),
                 "a"=matrix(data = c(0,0,0,0,0,
                                     0,0,0,0,0,
                                     0,1,1,0,0,
                                     0,0,0,1,0,
                                     0,1,1,1,0,
                                     1,0,0,1,0,
                                     0,1,1,0,1), nrow = 7, byrow = TRUE),
                 "b"=matrix(data = c(0,0,0,0,
                                     1,0,0,0,
                                     1,0,0,0,
                                     1,1,1,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,1,1,0), nrow = 7, byrow = TRUE),
                 "c"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     0,1,1,0,
                                     1,0,0,1,
                                     1,0,0,0,
                                     1,0,0,1,
                                     0,1,1,0), nrow = 7, byrow = TRUE),
                 "d"=matrix(data = c(0,0,0,0,
                                     0,0,0,1,
                                     0,0,0,1,
                                     0,1,1,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     0,1,1,1), nrow = 7, byrow = TRUE),
                 "e"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     0,1,1,0,
                                     1,0,0,1,
                                     1,1,1,1,
                                     1,0,0,0,
                                     0,1,1,1), nrow = 7, byrow = TRUE),
                 "f"=matrix(data = c(0,0,1,1,
                                     0,1,0,0,
                                     1,1,1,1,
                                     0,1,0,0,
                                     0,1,0,0,
                                     0,1,0,0,
                                     0,1,0,0), nrow = 7, byrow = TRUE),
                 "g"=matrix(data = c(0,0,0,0,
                                     0,1,1,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,1,1,1,
                                     0,0,0,1,
                                     1,1,1,0), nrow = 7, byrow = TRUE),
                 "h"=matrix(data = c(1,0,0,0,
                                     1,0,0,0,
                                     1,0,0,0,
                                     1,1,1,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,0,0,1), nrow = 7, byrow = TRUE),
                 "i"=matrix(data = c(0,0,1,
                                     0,0,0,
                                     1,1,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1), nrow = 7, byrow = TRUE),
                 "j"=matrix(data = c(0,0,1,
                                     0,0,0,
                                     1,1,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     1,1,0), nrow = 7, byrow = TRUE),
                 "k"=matrix(data = c(0,0,0,0,
                                     1,0,0,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,1,1,0,
                                     1,0,0,1,
                                     1,0,0,1), nrow = 7, byrow = TRUE),
                 "l"=matrix(data = c(1,1,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1), nrow = 7, byrow = TRUE),
                 "m"=matrix(data = c(0,0,0,0,0,
                                     0,0,0,0,0,
                                     1,1,1,1,0,
                                     1,0,1,0,1,
                                     1,0,1,0,1,
                                     1,0,1,0,1,
                                     1,0,1,0,1), nrow = 7, byrow = TRUE),
                 "n"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     1,1,1,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,0,0,1), nrow = 7, byrow = TRUE),
                 "o"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     0,1,1,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     0,1,1,0), nrow = 7, byrow = TRUE),
                 "p"=matrix(data = c(0,0,0,0,
                                     1,1,1,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,1,1,0,
                                     1,0,0,0,
                                     1,0,0,0), nrow = 7, byrow = TRUE),
                 "q"=matrix(data = c(0,0,0,0,
                                     0,1,1,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     0,1,1,1,
                                     0,0,0,1,
                                     0,0,0,1), nrow = 7, byrow = TRUE),
                 "r"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     0,1,1,0,
                                     1,0,0,1,
                                     1,0,0,0,
                                     1,0,0,0,
                                     1,0,0,0), nrow = 7, byrow = TRUE),
                 "s"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     0,1,1,1,
                                     1,0,0,0,
                                     0,1,1,0,
                                     0,0,0,1,
                                     1,1,1,0), nrow = 7, byrow = TRUE),
                 "t"=matrix(data = c(0,0,0,0,
                                     0,1,0,0,
                                     1,1,1,1,
                                     0,1,0,0,
                                     0,1,0,0,
                                     0,1,0,0,
                                     0,0,1,1), nrow = 7, byrow = TRUE),
                 "u"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     1,0,0,1,
                                     0,1,1,1), nrow = 7, byrow = TRUE),
                 "v"=matrix(data = c(0,0,0,0,0,
                                     0,0,0,0,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     0,1,0,1,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 "w"=matrix(data = c(0,0,0,0,0,
                                     0,0,0,0,0,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,1,0,1,
                                     0,1,0,1,0), nrow = 7, byrow = TRUE),
                 "x"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     0,1,1,0,
                                     1,0,0,1,
                                     1,0,0,1), nrow = 7, byrow = TRUE),
                 "y"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     1,0,0,1,
                                     1,0,0,1,
                                     0,1,1,1,
                                     0,0,0,1,
                                     1,1,1,0), nrow = 7, byrow = TRUE),
                 "z"=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     1,1,1,1,
                                     0,0,1,0,
                                     0,1,0,0,
                                     1,0,0,0,
                                     1,1,1,1), nrow = 7, byrow = TRUE),
                 "+"=matrix(data = c(0,0,0,
                                     0,0,0,
                                     0,1,0,
                                     1,1,1,
                                     0,1,0,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 "-"=matrix(data = c(0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     1,1,1,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 "_"=matrix(data = c(0,0,0,0,0,
                                     0,0,0,0,0,
                                     0,0,0,0,0,
                                     0,0,0,0,0,
                                     0,0,0,0,0,
                                     0,0,0,0,0,
                                     1,1,1,1,1), nrow = 7, byrow = TRUE),
                 "*"=matrix(data = c(0,0,0,
                                     0,0,0,
                                     1,0,1,
                                     0,1,0,
                                     1,0,1,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 "/"=matrix(data = c(0,0,0,
                                     0,0,0,
                                     0,0,1,
                                     0,1,0,
                                     1,0,0,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 "%"=matrix(data = c(0,0,0,0,0,
                                     1,1,0,0,1,
                                     1,1,0,1,0,
                                     0,0,1,0,0,
                                     0,1,0,1,1,
                                     1,0,0,1,1,
                                     0,0,0,0,0), nrow = 7, byrow = TRUE),
                 "&"=matrix(data = c(0,0,0,0,0,
                                     0,1,0,0,0,
                                     1,0,1,0,0,
                                     0,1,0,0,1,
                                     1,0,1,1,0,
                                     1,0,0,1,0,
                                     0,1,1,0,1), nrow = 7, byrow = TRUE),
                 "="=matrix(data = c(0,0,0,0,
                                     0,0,0,0,
                                     1,1,1,1,
                                     0,0,0,0,
                                     1,1,1,1,
                                     0,0,0,0,
                                     0,0,0,0), nrow = 7, byrow = TRUE),
                 "?"=matrix(data = c(0,1,1,1,0,
                                     1,0,0,0,1,
                                     0,0,0,1,0,
                                     0,0,1,0,0,
                                     0,0,1,0,0,
                                     0,0,0,0,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 "!"=matrix(data = c(1,
                                     1,
                                     1,
                                     1,
                                     1,
                                     0,
                                     1), nrow = 7, byrow = TRUE),
                 "."=matrix(data = c(0,0,
                                     0,0,
                                     0,0,
                                     0,0,
                                     1,1,
                                     1,1,
                                     0,0), nrow = 7, byrow = TRUE),
                 ":"=matrix(data = c(0,0,
                                     1,1,
                                     1,1,
                                     0,0,
                                     1,1,
                                     1,1,
                                     0,0), nrow = 7, byrow = TRUE),
                 ";"=matrix(data = c(0,0,0,
                                     0,1,1,
                                     0,1,1,
                                     0,0,0,
                                     0,1,1,
                                     0,0,1,
                                     0,1,0), nrow = 7, byrow = TRUE),
                 "`"=matrix(data = c(1,0,
                                     0,1,
                                     0,0,
                                     0,0,
                                     0,0,
                                     0,0,
                                     0,0), nrow = 7, byrow = TRUE),
                 ","=matrix(data = c(0,0,
                                     0,0,
                                     0,0,
                                     0,0,
                                     1,1,
                                     0,1,
                                     1,0), nrow = 7, byrow = TRUE),
                 ">"=matrix(data = c(1,0,0,0,
                                     0,1,0,0,
                                     0,0,1,0,
                                     0,0,0,1,
                                     0,0,1,0,
                                     0,1,0,0,
                                     1,0,0,0), nrow = 7, byrow = TRUE),
                 "<"=matrix(data = c(0,0,0,1,
                                     0,0,1,0,
                                     0,1,0,0,
                                     1,0,0,0,
                                     0,1,0,0,
                                     0,0,1,0,
                                     0,0,0,1), nrow = 7, byrow = TRUE),
                 "^"=matrix(data = c(0,1,0,
                                     1,0,1,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 "~"=matrix(data = c(0,0,0,0,0,
                                     0,0,0,0,0,
                                     0,1,0,0,0,
                                     1,0,1,0,1,
                                     0,0,0,1,0,
                                     0,0,0,0,0,
                                     0,0,0,0,0), nrow = 7, byrow = TRUE),
                 "#"=matrix(data = c(0,0,0,0,0,
                                     0,1,0,1,0,
                                     1,1,1,1,1,
                                     0,1,0,1,0,
                                     1,1,1,1,1,
                                     0,1,0,1,0,
                                     0,0,0,0,0), nrow = 7, byrow = TRUE),
                 "("=matrix(data = c(0,1,0,
                                     1,0,0,
                                     1,0,0,
                                     1,0,0,
                                     1,0,0,
                                     1,0,0,
                                     0,1,0), nrow = 7, byrow = TRUE),
                 ")"=matrix(data = c(0,1,0,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,1,0), nrow = 7, byrow = TRUE),
                 "["=matrix(data = c(1,1,1,
                                     1,0,0,
                                     1,0,0,
                                     1,0,0,
                                     1,0,0,
                                     1,0,0,
                                     1,1,1), nrow = 7, byrow = TRUE),
                 "]"=matrix(data = c(1,1,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     0,0,1,
                                     1,1,1), nrow = 7, byrow = TRUE),
                 "{"=matrix(data = c(0,0,1,
                                     0,1,0,
                                     0,1,0,
                                     1,1,0,
                                     0,1,0,
                                     0,1,0,
                                     0,0,1), nrow = 7, byrow = TRUE),
                 "}"=matrix(data = c(1,0,0,
                                     0,1,0,
                                     0,1,0,
                                     0,1,1,
                                     0,1,0,
                                     0,1,0,
                                     1,0,0), nrow = 7, byrow = TRUE),
                 "$"=matrix(data = c(0,0,1,0,0,
                                     0,1,1,1,1,
                                     1,0,1,0,0,
                                     0,1,1,1,0,
                                     0,0,1,0,1,
                                     1,1,1,1,0,
                                     0,0,1,0,0), nrow = 7, byrow = TRUE),
                 # non ASCII characters
                 # "euro"=matrix(data = c(0,0,1,1,1,0,
                 #                     0,1,0,0,0,1,
                 #                     1,1,1,1,0,0,
                 #                     0,1,0,0,0,0,
                 #                     1,1,1,1,0,0,
                 #                     0,1,0,0,0,1,
                 #                     0,0,1,1,1,0), nrow = 7, byrow = TRUE),
                 # "pound"=matrix(data = c(0,0,1,1,
                 #                     0,1,0,0,
                 #                     0,1,0,0,
                 #                     1,1,1,1,
                 #                     0,1,0,0,
                 #                     0,1,0,0,
                 #                     1,1,1,1), nrow = 7, byrow = TRUE),
                 "@"=matrix(data = c(0,0,1,1,1,0,0,0,
                                     0,1,0,0,0,1,0,0,
                                     1,0,0,1,1,0,1,0,
                                     1,0,1,0,1,0,1,0,
                                     1,0,1,1,1,0,1,0,
                                     1,0,0,0,0,0,0,1,
                                     0,1,1,1,1,1,0,0), nrow = 7, byrow = TRUE),
                 # | is used to have greek symbol mu for scale
                 "|"=matrix(data = c(1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,0,1,
                                     1,0,0,1,1,
                                     1,1,1,0,1,
                                     1,0,0,0,0,
                                     1,0,0,0,0), nrow = 7, byrow = TRUE),
                 " "=matrix(data = c(0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 '"'=matrix(data = c(1,0,1,
                                     1,0,1,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0,
                                     0,0,0), nrow = 7, byrow = TRUE),
                 "'"=matrix(data = c(1,
                                     1,
                                     0,
                                     0,
                                     0,
                                     0,
                                     0), nrow = 7, byrow = TRUE),
                 {# unknown character
                  matrix(data = c(1,1,1,
                                  1,0,1,
                                  1,0,1,
                                  1,0,1,
                                  1,0,1,
                                  1,0,1,
                                  1,1,1), nrow = 7, byrow = TRUE)}))
    })),0),0))
}
