% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.fqcs.R
\name{QuantileWalter}
\alias{QuantileWalter}
\title{It provides quantile estimates from FDA point of view.}
\usage{
QuantileWalter(x, quantile = 0.95, central = TRUE)
}
\arguments{
\item{x}{Object of type fdata}

\item{quantile}{Probability defined in the interval [0,1]}

\item{central}{Logical argument. If  FALSE, functional quantile q is computed. 
If TRUE, two functional quantiles are obtained, those corresponding to curves (1-q / 2) and q / 2 .}
}
\description{
It  develops a 'lab.fqcs' object to estimate functional quatiles by Walter's method (2011) from a pointwise point of view.
}
\examples{
\dontrun{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
n <- curves.fqcd$n
m <- curves.fqcd$m
p <- curves.fqcd$p
curves.all <- TG[,,1]
for(i in 2:p) curves.all <- rbind(curves.all,TG[,,i])
curves.fdata <- fdata(mdata = curves.all,delta)
qw <- QuantileWalter(curves.fdata)
windows(20,10)
par(mfrow=c(1,2))
plot(qw, main="Quantiles of TG curves (95\%)",col=c("red","blue"),lwd=2,legend = FALSE)
legend(50,80,c("Quantile 2.5\%","Quantile 97.5\%"),
      col=c("red","blue"),lty=c(1,1),lwd=1,cex=0.7)
plot(curves.fdata,main="Quantiles of TG curves (95\%)",col="gray")
for(i in 1:2)
lines(qw[[i]],col="red",lty = 2,lwd = 2)
legend(50,80,c("Quantiles","TG Curves (105)"),
      col=c("red","gray"),lty=c(1,2),lwd=2,cex=0.7)
par(mfrow=c(1,1))
}
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Walter, S. (2011), Defining Quantiles for Functional Data: with an Application to the Reversal of Stock Price Decreases, 
  Department of Math. and Stat. The Uni. of Melbourne.}
}
}

