% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weirdate.R
\name{weirddate}
\alias{weirddate}
\title{Locate impossible dates}
\usage{
weirddate(x)
}
\arguments{
\item{x}{two-columns dataframe. First column is date in the ECA&D format (yyyymmdd), second columns is value}
}
\value{
list of positions which do not pass this QC test. If all positions pass the test, returns NULL
}
\description{
This function is intended to flag impossible dates (e.g., 19990230 or 29990112, etc)
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "TX_SOUID132734.txt", package = "INQC")
#Read the data file
x<-readecad(input=path2inptfl,missing= -9999)[,3:4]
#Find all suspicious positions in the time series
weirddate(x)

#Introduce the weird dates
x[31,1]<-'19610132'
#Find all suspicious positions in the time series
weirddate(x) 
}
