% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windspeed.R
\name{windspeed}
\alias{windspeed}
\title{QC for Wind Speed (FG)}
\usage{
windspeed(
  element = "FG",
  maxseq = 3,
  blocksizeround = 20,
  blockmanymonth = 20,
  blockmanyyear = 200,
  large = 3000,
  roundmax = 10,
  level = 5,
  window = 30,
  ret = 500,
  margina = 0.999,
  inisia = FALSE
)
}
\arguments{
\item{element}{two-letters ECA&D code for the element (e.g., FG for wind speed)}

\item{maxseq}{maximum number of consecutive repeated values, FUNCTION: flat  (11.1,11.1,11.1 would be 3 consecutive values)}

\item{blocksizeround}{maximum number of values in a month with the same decimal, FUNCTION: rounding()}

\item{blockmanymonth}{maximum number of equal values in a month, FUNCTION: toomany()}

\item{blockmanyyear}{maximum number of equal values in a year, FUNCTION: toomany()}

\item{large}{value above which the observation is considered physically impossible for the region, FUNCTION: physics()}

\item{roundmax}{maximum number of consecutive decimal part value, for flat function (10.0, 11.0, 12.0 would be 3 consecutive values)}

\item{level}{number of IQRs for IQR outliers}

\item{window}{window, in days, for IQR outliers}

\item{ret}{pseudo-return period for the Pareto outliers}

\item{margina}{quantile for newfriki function}

\item{inisia}{a logical flag. If it is TRUE inithome() will be called}
}
\value{
results of QC for FG
}
\description{
This function will centralize temperature-like QC routines. It will create a file in the folder QC
with an additional 0/1 column, where "1" means test failed.
}
\examples{
#Set a temporal working directory:
wd <- tempdir()
wd0 <- setwd(wd)
#Create subdirectory where raw data files have to be located
dir.create(file.path(wd, 'raw'))
options("homefolder"='./'); options("blend"=FALSE)
#Extract the ECA&D data and station files from the example data folder
path2fglist<-system.file("extdata", "ECA_blend_source_fg.txt", package = "INQC")
fglist<-readr::read_lines_raw(path2fglist)
readr::write_lines(fglist,'ECA_blend_source_fg.txt')
path2fgdata<-system.file("extdata", "FG_SOUID132736.txt", package = "INQC")
fgdata<-readr::read_lines_raw(path2fgdata)
readr::write_lines(fgdata, file=paste(wd,'/raw/FG_SOUID132736.txt',sep=''))
#Perform QC of Wind Speed data
windspeed(inisia=TRUE)
#Remove some temporary files
list = list.files(pattern = "Rfwf")
file.remove(list)
#Return to user's working directory:
setwd(wd0)
#The QC results can be found in the directory:
print(wd)
}
