% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INSPIRE.R
\name{INSPIRE}
\alias{INSPIRE}
\title{Inferring Shared Modules from Multiple Gene Expression Datasets with Partially Overlapping Gene Sets}
\usage{
INSPIRE(datasetlist, mcnt, lambda, printoutput = 0, maxinitKMiter = 100,
  maxiter = 100, threshold = 0.01, initseed = 123)
}
\arguments{
\item{datasetlist}{A list of gene expression matrices of size n_i x p_i where rows represent samples and columns represent genes for each dataset i.  This can be created by using the list() command, e.g., list(dataset1, dataset2, dataset3)}

\item{mcnt}{A positive integer representing the number of modules to learn from the data}

\item{lambda}{A penalty parameter that regularizes the estimated precision matrix representing the conditional dependencies among the modules}

\item{printoutput}{0 or 1 representing whether the progress of the algorithm should be displayed (0 means no display which is the default)}

\item{maxinitKMiter}{Maximum number of K-means iterations performed to initialize the parameters (the default is 100 iterations)}

\item{maxiter}{Maximum number of INSPIRE iterations performed to update the parameters (the default is 100 iterations)}

\item{threshold}{Convergence threshold measured as the relative change in the sum of the elements of the estimated precision matrices in two consecutive iterations (the default is 10^-2)}

\item{initseed}{The random seed set right before the K-means call which is performed to initialize the parameters}
}
\value{
\item{L}{A matrix of size (sum_n_i) x mcnt representing the inferred latent variables (the low-dimensional representation - or LDR - of the data)}

\item{Z}{A list of vectors of size p_i representing the learned assignment of each of the genes in each dataset i to one of mcnt modules}

\item{theta}{Estimated precision matrix of size mcnt x mcnt representing the conditional dependencies among the modules}
}
\description{
Takes a list of data matrices, with potentially different number of genes, number of modules, and a penalty parameter,
and returns the final assignment of the data points in each dataset to the modules, the values of the module latent variables, 
and the conditional dependency network among the module latent variables.
}
\examples{
\dontrun{
library(INSPIRE)
mcnt = 90 #module size
lambda = .1 #penalty parameter to induce sparsity
# download two real gene expression datasets, where the rows are genes and columns are samples
data('two_example_datasets')
# log-normalize, and standardize each dataset
res = INSPIRE(list(scale(log(exmp_dataset1)), scale(log(exmp_dataset2))), mcnt, lambda)
}
}

