% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSet.R, R/DataSetList.R
\name{get_PAR_sample}
\alias{get_PAR_sample}
\alias{get_PAR_sample.DataSet}
\alias{get_PAR_sample.DataSetList}
\title{Get Parameter Value Samples}
\usage{
get_PAR_sample(ds, idxValue, ...)

\method{get_PAR_sample}{DataSet}(
  ds,
  idxValue,
  parId = "all",
  which = "by_FV",
  output = "wide",
  ...
)

\method{get_PAR_sample}{DataSetList}(ds, idxValue, algorithm = "all", ...)
}
\arguments{
\item{ds}{A DataSet or DataSetList object}

\item{idxValue}{A Numerical vector. Index values at which parameter values are observed.
The index value can either take its value in the range of running times, or function values.
Such a value type is signified by `which` parameter.}

\item{...}{Arguments passed to other methods}

\item{parId}{A character vector. Either 'all' or the name of parameters to be retrieved}

\item{which}{A string takes values in `c('by_FV', 'by_RT')`, indicating the parameters to be
retrieved are aligned against the running time (RT) or function value (FV). `'by_FV'`
is the default value.}

\item{output}{A character. The format of the output data: 'wide' or 'long'}

\item{algorithm}{DEPRECATED, will be removed in next release. Which algorithms in the DataSetList to consider.}
}
\value{
A data.table object containing parameter values aligned at each given target value
}
\description{
Get Parameter Value Samples
}
\examples{
get_PAR_sample(dsl, 14)
get_PAR_sample(dsl[[1]], 14)
}
