% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_items.R
\name{coord_items}
\alias{coord_items}
\title{Coord Items}
\usage{
coord_items(
  data,
  rotate_radians = 0,
  rotate_degrees = 0,
  dist_test_label = 0.5,
  rotate_test_label_radians = 0,
  rotate_test_label_degrees = 0,
  width_items = 1,
  length_items = 1,
  length_ratio_items = 1.5,
  dodge = 1
)
}
\arguments{
\item{data}{SEM estimates in the appropriate format, given by the input
functions.}

\item{rotate_radians}{integer; radian angle to rotate the chart
counter-clockwise by; use fractions of pi (e.g. pi/2 = 90 degrees).}

\item{rotate_degrees}{integer; angle in degrees to rotate the chart
counter-clockwise by.}

\item{dist_test_label}{integer; position of the test label relative to the
surrounding circle; defaults to .5, in which case the test label is
displayed halfway from the center to the surrounding circle.}

\item{rotate_test_label_radians}{integer; radian angle to rotate the test
label counter-clockwise by; use fractions of pi (e.g. pi/2 = 90 degrees).}

\item{rotate_test_label_degrees}{integer; angle in degrees to rotate the test
label counter-clockwise by.}

\item{width_items}{integer; item bar width relative to default.}

\item{length_items}{integer; item bar length relative to default.}

\item{length_ratio_items}{integer; relative item bar length; defaults to 1.5.}

\item{dodge}{integer; horizontal outward dodge of facet labels relative to
default.}
}
\value{
List containing coordinates of chart objects.
}
\description{
Generates the coordinates for an item chart.
}
\details{
Use \code{\link{item_chart}} to create item charts.
}
\seealso{
\code{\link{plot_items}} \code{\link{coord_nested}}
  \code{\link{item_chart}}
}
