% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/itemfit.R
\name{z3_personf}
\alias{z3_personf}
\title{Z3 Person fit statistic}
\usage{
z3_personf(data, zita, patterns)
}
\arguments{
\item{data}{dataset}

\item{zita}{list of estimations of the parameters of the items (discrimination,difficulty, guessing)}

\item{patterns}{matrix of patterns response, the frequency of each pattern and the latent traits}
}
\description{
calculates the Z3 values from Fritz Drasgow, Michael V. Levine and Esther A. Williams
}
\examples{
#Simulates a test and returns a list:
test=simulateTest()

#the simulated data:
data=test$test

#model:
mod=irtpp(dataset = data,model = "3PL")

#latent trait:
zz=parameter.matrix(mod$z)
p_mat=mod$prob_mat
traits=individual.traits(model="3PL",method = "EAP",dataset = data,itempars = zz,
probability_matrix=p_mat)

#Z3 PERSONFIT-Statistic
z3_personf(data = data,zita = mod$z,patterns = traits)
}
\author{
SICS Research, National University of Colombia \email{ammontenegrod@unal.edu.co}
}
\references{
Fritz Drasgow, Michael V. Levine and Esther A. Williams (1985). Appropiateness measurement with polychotomous item response models and standarized indices.
}
\seealso{
\code{\link{z3_itemf}}, \code{\link{orlando_itemf}}
}

