% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISS.R
\name{ISS}
\alias{ISS}
\title{ISS}
\usage{
ISS(
  X,
  y,
  tau,
  alpha = 0.05,
  m = nrow(X),
  p_value = c("sub-Gaussian-normalmixture", "sub-Gaussian", "classification"),
  sigma2,
  rho = 1/2,
  DAG_testing_procedure = c("ISS", "Holm", "MG all", "MG any"),
  minimal = FALSE
)
}
\arguments{
\item{X}{a numeric matrix specifying the covariates.}

\item{y}{a numeric vector with \code{length(y) == nrow(X)} specifying the responses.}

\item{tau}{a single numeric value specifying the threshold of interest.}

\item{alpha}{a numeric value in (0, 1] specifying the Type I error rate.}

\item{m}{an integer value between 1 and \code{nrow(X)} specifying the size of
the subsample of \code{X} at which the hypotheses should be tested.}

\item{p_value}{one of \code{c("sub-Gaussian", "sub-Gaussian-normalmixture", "classification")} specifying
which p-value construction should be used. See Definitions 1, 18 and 19 by \insertCite{MRCS2023;textual}{ISS} respectively.}

\item{sigma2}{a single positive numeric value specifying the variance parameter (only needed if \code{p_value == "sub-Gaussian"} or \code{p_value == "sub-Gaussian-normalmixture"}).}

\item{rho}{a single positive numeric value serving as hyperparameter (only used if \code{p_value == "sub-Gaussian-normalmixture"}).}

\item{DAG_testing_procedure}{one of \code{c("ISS", "Holm", "MG all", "MG any")}, specifying how the
familywise error rate is controlled. The first corresponds to Algorithm 1 by \insertCite{MRCS2023;textual}{ISS},
the second is Holm's procedure and the final two correspond to the procedures due to \insertCite{meijer2015multiple;textual}{ISS}
for one-way logical relationships.}

\item{minimal}{a logical value determining whether the output should be reduced to the minimal number of points leading to the same selected set.}
}
\value{
A numeric matrix giving the points in \code{X} determined to lie in the \code{tau}-superlevel set of the regression function with probability at least 1 - \code{alpha} or, if \code{minimal == TRUE}, a subset of points thereof that have the same upper hull.
}
\description{
The function implements the combination of p-value calculation and familywise
error rate control through DAG testing procedures described in \insertCite{MRCS2023;textual}{ISS}.
}
\examples{
d <- 2
n <- 1000
m <- 100
sigma2 <- (1 / 4)^2
tau <- 0.5
alpha <- 0.05

X <- matrix(runif(n * d), nrow = n)
eta_X <- apply(X, MARGIN = 1, max)
y <- eta_X + rnorm(n, sd = sqrt(sigma2))
X_rej <- ISS(X = X, y = y, tau = tau, alpha = alpha, m = m, sigma2 = sigma2)

if (d == 2) {
  plot(0, type = "n", xlim = c(0, 1), ylim = c(0, 1), xlab = NA, ylab = NA)
  for (i in 1:nrow(X_rej)) {
    rect(
      xleft = X_rej[i, 1], xright = 1, ybottom = X_rej[i, 2], ytop = 1,
      border = NA, col = "indianred"
    )
  }

  points(X, pch = 16, cex = 0.5, col = "gray")
  points(X[1:m, ], pch = 16, cex = 0.5, col = "black")
  lines(x = c(0, tau), y = c(tau, tau), lty = 2)
  lines(x = c(tau, tau), y = c(tau, 0), lty = 2)

  legend(
    x = "bottomleft",
    legend = c(
      "superlevel set boundary",
      "untested covariate points",
      "tested covariate points",
      "selected set"
    ),
    col = c("black", "gray", "black", "indianred"),
    lty = c(2, NA, NA, NA),
    lwd = c(1, NA, NA, NA),
    pch = c(NA, 16, 16, NA),
    fill = c(NA, NA, NA, "indianred"),
    border = c(NA, NA, NA, "indianred")
  )
}

}
\references{
\insertRef{meijer2015multiple}{ISS}

\insertRef{MRCS2023}{ISS}
}
