% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EI_group_function.R
\name{ei_group}
\alias{ei_group}
\title{Group level E-I Index}
\usage{
ei_group(gs, attrname)
}
\arguments{
\item{gs}{igraph object}

\item{attrname}{Attribute name}
}
\value{
Group level results dataframe
}
\description{
This function calculates the E-I Index (External-internal) at the group/attribute level
}
\examples{
require(igraph)
##Create random network (igraph object)
gs<-erdos.renyi.game(75,0.05,directed = TRUE)

##Add vertex names
V(gs)$name<-1:vcount(gs)

## Add an attribute
V(gs)$letters<- rep(LETTERS[1:5],15)

##Calculate the Group E-I Results
EI_GROUP_DATAFRAME<-ei_group(gs,"letters")

}
