% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{findHoles}
\alias{findHoles}
\title{Find holes in a polygon}
\usage{
findHoles(myPoly, myReg, myOut)
}
\arguments{
\item{myPoly}{\code{SpatialPolygons} object of interest}

\item{myReg}{\code{SpatialPolygons} object for the region which myPoly is in}

\item{myOut}{\code{SpatialPolygons} object that is outside the region, but that borders the regions' fixed line. This polygon is used to determine if points are being mapped outside the region of interest.}
}
\value{
list where \code{new$holes} gives the holes in the polygons as a \code{SpatialPolygons} object and \code{new$newPoly}
gives a \code{SpatialPolygons} object with the holes removed.
}
\description{
Function to find and remove holes in a \code{SpatialPolygons} object. Note that this function differs from the function \code{rmHoles} in that it is considering gaps between a polygon and region boundaries in addition to holes contained within the polygon itself.
}
\examples{
holeEx <- findHoles(regionInfo$regions[[1]], regionInfo$regions[[1]], regionInfo$out[[1]])
plot(holeEx$newPoly)
plot(holeEx$holes, col = "red", add = TRUE)
}
