% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RGT_cycle_14}
\alias{RGT_cycle_14}
\title{Reference Ground Tracks (RGTs) for IceSat-2 Cycle 14}
\format{
An object of class \code{data.table} (inherits from \code{data.frame}) with 131765 rows and 8 columns.
}
\usage{
data(RGT_cycle_14)
}
\description{
The data includes the following columns: "longitude", "latitude", "day_of_year", "Date", "hour", "minute", "second" and "RGT". The "RGT" column consists of
1387 Reference Ground Tracks (RGTs) for the IceSat-2 Cycle 14 (from 'December 22, 2021' to 'March 23, 2022')
}
\details{
The following code snippet shows how to come to the "RGT_cycle_14" data. The same can be done with any of the available RGT Cycles. For the following code
I utilized 8 threads to speed up the pre-processing of the downloaded .kml files (the code takes approximately 15 minutes on my Linux Personal Computer),

\code{require(IceSat2R)} \cr
\code{require(magrittr)} \cr
\code{require(sf)} \cr

\code{avail_cycles = available_RGTs(only_cycle_names = TRUE)} \cr
\code{avail_cycles} \cr

\code{idx_cycle = 14} \cr

\code{choose_cycle = avail_cycles[idx_cycle]} \cr
\code{choose_cycle} \cr

\code{res_rgt_many = time_specific_orbits(RGT_cycle = choose_cycle, download_method = 'curl', threads = parallel::detectCores(), verbose = TRUE)} \cr

\code{RGT_cycle_14 = sf::st_coordinates(res_rgt_many)} \cr
\code{colnames(RGT_cycle_14) = c('longitude', 'latitude')} \cr
\code{RGT_cycle_14 = data.table::data.table(RGT_cycle_14)} \cr
\code{RGT_cycle_14$day_of_year = res_rgt_many$day_of_year} \cr
\code{RGT_cycle_14$Date = as.Date(res_rgt_many$Date_time)} \cr
\code{RGT_cycle_14$hour = lubridate::hour(res_rgt_many$Date_time)} \cr
\code{RGT_cycle_14$minute = lubridate::minute(res_rgt_many$Date_time)} \cr
\code{RGT_cycle_14$second = lubridate::second(res_rgt_many$Date_time)} \cr
\code{RGT_cycle_14$RGT = res_rgt_many$RGT} \cr
\code{RGT_cycle_14} \cr
}
\examples{

require(IceSat2R)
require(data.table)

data(RGT_cycle_14)
}
\references{
https://icesat-2.gsfc.nasa.gov/science/specs
}
\keyword{datasets}
