% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IM4E.R
\name{IM4E}
\alias{IM4E}
\title{IM4E}
\usage{
IM4E(train_xx, train_yy, epsilon = 0.01, sig = 1, lambda = 1,
  max_iter = 10, removesmall = FALSE)
}
\arguments{
\item{train_xx}{model matrix of explanatory variables}

\item{train_yy}{label vector}

\item{epsilon}{criterion for stopping iteration}

\item{sig}{sigma used in algorithm, default to be 1}

\item{lambda}{lambda used in algorithm, default to be 1}

\item{max_iter}{maximum number of iteration}

\item{removesmall}{whether remove features with small weights, default to be FALSE}
}
\value{
\item{w}{new weight after one loop}

\item{iter_num}{number of iteration for convergence}

\item{final_c}{final cost}
}
\description{
This function performs IM4E(Iterative Margin-Maximization under Max-Min Entropy) algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
re<-IM4E(xx,yy)
print(re)
}
\references{
Bei Y, Hong P. Maximizing margin quality and quantity[C]//Machine Learning for Signal Processing (MLSP), 2015 IEEE 25th International Workshop on. IEEE, 2015: 1-6.
}
\keyword{IM4E}
