% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolutionSource.R
\name{SolutionSource}
\alias{SolutionSource}
\title{Obtaining indexes associated with the solution sources.}
\usage{
SolutionSource(SolutionData,Production,EffectivenessOfSolution,Id,Verbose=TRUE)
}
\arguments{
\item{SolutionData}{It is an matrix object containing data from Solution sources.}

\item{Production}{Matrix with a column containing the production data.}

\item{EffectivenessOfSolution}{Output generated by the function  `EffectivenessOfSolution`}

\item{Id}{Logical vector indicating the lines of the `EffectivenessOfSolution` that are relevant.
Output generated by the function SelectEffectivenessOfSolution}

\item{Verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the analysis.}
}
\value{
The function returns indices associated with the source of loss.
}
\description{
Function to estimate the total n of the S.S. (n), E.S., ks, c, ds, n.I.I.,
Sum.n.I.I., and percentage of I.I. (P.I.I.) by each S.S..
}
\examples{
library(ImportanceIndice)
data("DataLossSource")
data("DataSolutionSource")
data("DataProduction")
data("DataNumberSamples")

Distribution_LossSource(DataLossSource)
Distribution_SolutionSource(DataSolutionSource)

#################################################
###################################################



LS=LossSource(DataLoss = DataLossSource,DataProd = DataProduction,verbose = TRUE)
LS

LP=LossProduction(Data=DataLossSource,Prod = DataProduction,
                 Evaluation=DataNumberSamples,
                 SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
LP


ES=EffectivenessOfSolution(DataLossSource=DataLossSource,
                          DataSolutionSource=DataSolutionSource,Production =DataProduction)
ES




id=SelectEffectivenessOfSolution(ES)
id=c(TRUE , TRUE,  TRUE , FALSE,  TRUE)


SS=SolutionSource(SolutionData = DataSolutionSource,
                 EffectivenessOfSolution = ES,Production = DataProduction,Id = id)
SS


NAL=NonAttentionLevel(EffectivenessOfSolution = ES,LossProduction = LP,Id = id,Verbose=TRUE)
NAL
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
