/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatBiCGstab
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D p;
    private FloatMatrix1D s;
    private FloatMatrix1D phat;
    private FloatMatrix1D shat;
    private FloatMatrix1D t;
    private FloatMatrix1D v;
    private FloatMatrix1D temp;
    private FloatMatrix1D r;
    private FloatMatrix1D rtilde;

    public FloatBiCGstab(FloatMatrix1D floatMatrix1D) {
        this.p = floatMatrix1D.copy();
        this.s = floatMatrix1D.copy();
        this.phat = floatMatrix1D.copy();
        this.shat = floatMatrix1D.copy();
        this.t = floatMatrix1D.copy();
        this.v = floatMatrix1D.copy();
        this.temp = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
        this.rtilde = floatMatrix1D.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            f = this.rtilde.zDotProduct(this.r);
            if (f == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (f5 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "omega", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.r);
            } else {
                f4 = f / f2 * (f3 / f5);
                this.temp.assign(this.v, FloatFunctions.multSecond(-f5)).assign(this.p, FloatFunctions.plus);
                this.p.assign(this.r).assign(this.temp, FloatFunctions.plusMultSecond(f4));
            }
            this.M.apply(this.p, this.phat);
            floatMatrix2D.zMult(this.phat, this.v);
            f3 = f / this.rtilde.zDotProduct(this.v);
            this.s.assign(this.r).assign(this.v, FloatFunctions.plusMultSecond(-f3));
            if (this.iter.converged(this.s, floatMatrix1D2)) {
                return floatMatrix1D2.assign(this.phat, FloatFunctions.plusMultSecond(f3));
            }
            this.M.apply(this.s, this.shat);
            floatMatrix2D.zMult(this.shat, this.t);
            f5 = this.t.zDotProduct(this.s) / this.t.zDotProduct(this.t);
            floatMatrix1D2.assign(this.phat, FloatFunctions.plusMultSecond(f3));
            floatMatrix1D2.assign(this.shat, FloatFunctions.plusMultSecond(f5));
            this.r.assign(this.s).assign(this.t, FloatFunctions.plusMultSecond(-f5));
            f2 = f;
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

