/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import junit.framework.TestCase;
import org.junit.Test;

public abstract class DoubleMatrix1DTest
extends TestCase {
    protected DoubleMatrix1D A;
    protected DoubleMatrix1D B;
    protected int SIZE = 170;
    protected double TOL = 1.0E-10;

    public DoubleMatrix1DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        ConcurrencyUtils.setThreadsBeginN_1D(1);
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.A.setQuick(n, Math.random());
        }
        for (n = 0; n < (int)this.B.size(); ++n) {
            this.B.setQuick(n, Math.random());
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunction() {
        double d = 0.0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double d2 = this.A.getQuick(i);
            d += d2 * d2;
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        DoubleMatrix1DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunctionIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            intArrayList.add(i);
        }
        double d = 0.0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double d2 = this.A.getQuick(i);
            d += d2 * d2;
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList);
        DoubleMatrix1DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleMatrix2DDoubleDoubleFunctionDoubleDoubleFunction() {
        double d = 0.0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double d2 = this.A.getQuick(i);
            double d3 = this.B.getQuick(i);
            d += d2 * d3;
        }
        double d4 = this.A.aggregate(this.B, DoubleFunctions.plus, DoubleFunctions.mult);
        DoubleMatrix1DTest.assertEquals((double)d, (double)d4, (double)this.TOL);
    }

    public void testAssignDouble() {
        double d = Math.random();
        this.A.assign(d);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)d, (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testAssignDoubleArray() {
        int n;
        double[] dArray = new double[(int)this.A.size()];
        for (n = 0; n < (int)this.A.size(); ++n) {
            dArray[n] = Math.random();
        }
        this.A.assign(dArray);
        for (n = 0; n < (int)this.A.size(); ++n) {
            DoubleMatrix1DTest.assertEquals((double)dArray[n], (double)this.A.getQuick(n), (double)this.TOL);
        }
    }

    public void testAssignDoubleFunction() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        this.A.assign(DoubleFunctions.acos);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double d = Math.acos(doubleMatrix1D.getQuick(i));
            DoubleMatrix1DTest.assertEquals((double)d, (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testAssignDoubleMatrix1D() {
        this.A.assign(this.B);
        DoubleMatrix1DTest.assertTrue((this.A.size() == this.B.size() ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)this.B.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testAssignDoubleMatrix1DDoubleDoubleFunction() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        this.A.assign(this.B, DoubleFunctions.div);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)(doubleMatrix1D.getQuick(i) / this.B.getQuick(i)), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testAssignDoubleProcedureDouble() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        this.A.assign(doubleProcedure, -1.0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (Math.abs(doubleMatrix1D.getQuick(i)) > 0.1) {
                DoubleMatrix1DTest.assertEquals((double)-1.0, (double)this.A.getQuick(i), (double)this.TOL);
                continue;
            }
            DoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testAssignDoubleProcedureDoubleFunction() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        this.A.assign(doubleProcedure, DoubleFunctions.tan);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (Math.abs(doubleMatrix1D.getQuick(i)) > 0.1) {
                DoubleMatrix1DTest.assertEquals((double)Math.tan(doubleMatrix1D.getQuick(i)), (double)this.A.getQuick(i), (double)this.TOL);
                continue;
            }
            DoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DoubleMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)n);
    }

    public void testEqualsDouble() {
        double d = 1.0;
        this.A.assign(d);
        boolean bl = this.A.equals(d);
        DoubleMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2.0);
        DoubleMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        DoubleMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        DoubleMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0.0);
        this.A.setQuick((int)this.A.size() / 3, 0.7);
        this.A.setQuick((int)this.A.size() / 2, 0.1);
        double[] dArray = this.A.getMaxLocation();
        DoubleMatrix1DTest.assertEquals((double)0.7, (double)dArray[0], (double)this.TOL);
        DoubleMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)((int)dArray[1]));
    }

    public void testMinLocation() {
        this.A.assign(0.0);
        this.A.setQuick((int)this.A.size() / 3, -0.7);
        this.A.setQuick((int)this.A.size() / 2, -0.1);
        double[] dArray = this.A.getMinLocation();
        DoubleMatrix1DTest.assertEquals((double)-0.7, (double)dArray[0], (double)this.TOL);
        DoubleMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)((int)dArray[1]));
    }

    public void testGetNegativeValuesIntArrayListDoubleArrayList() {
        this.A.assign(0.0);
        this.A.setQuick((int)this.A.size() / 3, -0.7);
        this.A.setQuick((int)this.A.size() / 2, -0.1);
        IntArrayList intArrayList = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getNegativeValues(intArrayList, doubleArrayList);
        DoubleMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix1DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        DoubleMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        DoubleMatrix1DTest.assertTrue((boolean)doubleArrayList.contains(-0.7));
        DoubleMatrix1DTest.assertTrue((boolean)doubleArrayList.contains(-0.1));
    }

    public void testGetNonZerosIntArrayListDoubleArrayList() {
        this.A.assign(0.0);
        this.A.setQuick((int)this.A.size() / 3, 0.7);
        this.A.setQuick((int)this.A.size() / 2, 0.1);
        IntArrayList intArrayList = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getNonZeros(intArrayList, doubleArrayList);
        DoubleMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix1DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        DoubleMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        DoubleMatrix1DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
        DoubleMatrix1DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
    }

    public void testGetPositiveValuesIntArrayListDoubleArrayList() {
        this.A.assign(0.0);
        this.A.setQuick((int)this.A.size() / 3, 0.7);
        this.A.setQuick((int)this.A.size() / 2, 0.1);
        IntArrayList intArrayList = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getPositiveValues(intArrayList, doubleArrayList);
        DoubleMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix1DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        DoubleMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        DoubleMatrix1DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
        DoubleMatrix1DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
    }

    public void testToArray() {
        double[] dArray = this.A.toArray();
        DoubleMatrix1DTest.assertTrue(((int)this.A.size() == dArray.length ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)dArray[i], (double)this.A.getQuick(i), (double)this.TOL);
        }
    }

    public void testToArrayDoubleArray() {
        double[] dArray = new double[(int)this.A.size()];
        this.A.toArray(dArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(i), (double)dArray[i], (double)this.TOL);
        }
    }

    public void testReshapeIntInt() {
        int n = 10;
        int n2 = 17;
        DoubleMatrix2D doubleMatrix2D = this.A.reshape(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(n3++), (double)doubleMatrix2D.getQuick(j, i), (double)this.TOL);
            }
        }
    }

    public void testReshapeIntIntInt() {
        int n = 2;
        int n2 = 5;
        int n3 = 17;
        DoubleMatrix3D doubleMatrix3D = this.A.reshape(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(n4++), (double)doubleMatrix3D.getQuick(i, k, j), (double)this.TOL);
                }
            }
        }
    }

    public void testSwap() {
        DoubleMatrix1D doubleMatrix1D = this.A.copy();
        DoubleMatrix1D doubleMatrix1D2 = this.B.copy();
        this.A.swap(this.B);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)doubleMatrix1D2.getQuick(i), (double)this.A.getQuick(i), (double)this.TOL);
            DoubleMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)this.B.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewFlip() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewFlip();
        DoubleMatrix1DTest.assertEquals((long)((int)this.A.size()), (long)doubleMatrix1D.size());
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(i), (double)doubleMatrix1D.getQuick((int)this.A.size() - 1 - i), (double)this.TOL);
        }
    }

    public void testViewPart() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewPart(15, 11);
        for (int i = 0; i < 11; ++i) {
            DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(15 + i), (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewSelectionDoubleProcedure() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewSelection(new DoubleProcedure(){

            public boolean apply(double d) {
                return d % 2.0 == 0.0;
            }
        });
        int n = 0;
        while ((long)n < doubleMatrix1D.size()) {
            double d = doubleMatrix1D.getQuick(n);
            if (d % 2.0 != 0.0) {
                DoubleMatrix1DTest.fail();
            }
            ++n;
        }
    }

    public void testViewSelectionIntArray() {
        int[] nArray = new int[]{5, 11, 22, 37, 101};
        DoubleMatrix1D doubleMatrix1D = this.A.viewSelection(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(nArray[i]), (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewSorted() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewSorted();
        for (int i = 0; i < (int)this.A.size() - 1; ++i) {
            DoubleMatrix1DTest.assertTrue((doubleMatrix1D.getQuick(i + 1) >= doubleMatrix1D.getQuick(i) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        DoubleMatrix1D doubleMatrix1D = this.A.viewStrides(n);
        int n2 = 0;
        while ((long)n2 < doubleMatrix1D.size()) {
            DoubleMatrix1DTest.assertEquals((double)this.A.getQuick(n2 * n), (double)doubleMatrix1D.getQuick(n2), (double)this.TOL);
            ++n2;
        }
    }

    public void testZDotProductDoubleMatrix1D() {
        double d = this.A.zDotProduct(this.B);
        double d2 = 0.0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            d2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        DoubleMatrix1DTest.assertEquals((double)d2, (double)d, (double)this.TOL);
    }

    public void testZDotProductDoubleMatrix1DIntInt() {
        double d = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10);
        double d2 = 0.0;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            d2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        DoubleMatrix1DTest.assertEquals((double)d2, (double)d, (double)this.TOL);
    }

    @Test
    public void testZDotProductDoubleMatrix1DIntIntIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.B.getNonZeros(intArrayList, doubleArrayList);
        double d = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10, intArrayList);
        double d2 = 0.0;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            d2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        DoubleMatrix1DTest.assertEquals((double)d2, (double)d, (double)this.TOL);
    }

    public void testZSum() {
        double d = this.A.zSum();
        double d2 = 0.0;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            d2 += this.A.getQuick(i);
        }
        DoubleMatrix1DTest.assertEquals((double)d2, (double)d, (double)this.TOL);
    }
}

