/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DelegateDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DiagonalDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperDoubleMatrix2D
extends DoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix2D content;

    public WrapperDoubleMatrix2D(DoubleMatrix2D doubleMatrix2D) {
        block3: {
            if (doubleMatrix2D != null) {
                try {
                    this.setUp(doubleMatrix2D.rows(), doubleMatrix2D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = doubleMatrix2D;
    }

    public DoubleMatrix2D assign(final double[] dArray) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            int n = ((DiagonalDoubleMatrix2D)this.content).dlength;
            final double[] dArray2 = ((DiagonalDoubleMatrix2D)this.content).elements;
            if (dArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + dArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                dArray2[i] = dArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = dArray[i];
                }
            }
            return this;
        }
        return super.assign(dArray);
    }

    public DoubleMatrix2D assign(final float[] fArray) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            int n = ((DiagonalDoubleMatrix2D)this.content).dlength;
            final double[] dArray = ((DiagonalDoubleMatrix2D)this.content).elements;
            if (fArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                dArray[i] = fArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = fArray[i];
                }
            }
            return this;
        }
        return super.assign(fArray);
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof WrapperDoubleMatrix2D) {
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            doubleMatrix2D.getNonZeros(intArrayList, intArrayList2, doubleArrayList);
            this.assign(doubleMatrix2D, doubleDoubleFunction, intArrayList, intArrayList2);
        } else {
            super.assign(doubleMatrix2D, doubleDoubleFunction);
        }
        return this;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized double getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(double d) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            double d2 = DoubleProperty.DEFAULT.tolerance();
            double[] dArray = (double[])this.content.elements();
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                double d4 = Math.abs(d - d3);
                if (d4 != d4 && (d != d && d3 != d3 || d == d3)) {
                    d4 = 0.0;
                }
                if (d4 <= d2) continue;
                return false;
            }
            return true;
        }
        return super.equals(d);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalDoubleMatrix2D && object instanceof DiagonalDoubleMatrix2D) {
            double d = DoubleProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D = (DiagonalDoubleMatrix2D)this.content;
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D2 = (DiagonalDoubleMatrix2D)object;
            if (diagonalDoubleMatrix2D.columns() != diagonalDoubleMatrix2D2.columns() || diagonalDoubleMatrix2D.rows() != diagonalDoubleMatrix2D2.rows() || diagonalDoubleMatrix2D.diagonalIndex() != diagonalDoubleMatrix2D2.diagonalIndex() || diagonalDoubleMatrix2D.diagonalLength() != diagonalDoubleMatrix2D2.diagonalLength()) {
                return false;
            }
            double[] dArray = diagonalDoubleMatrix2D.elements();
            double[] dArray2 = diagonalDoubleMatrix2D2.elements();
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray2[i];
                double d3 = dArray[i];
                double d4 = Math.abs(d2 - d3);
                if (d4 != d4 && (d2 != d2 && d3 != d3 || d2 == d3)) {
                    d4 = 0.0;
                }
                if (d4 <= d) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public DoubleMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void dct2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dct2(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dct2(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctColumns(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dctColumns(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dctColumns(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctRows(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dctRows(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dctRows(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dst2(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dst2(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstColumns(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dstColumns(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dstColumns(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstRows(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dstRows(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dstRows(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dht2();
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dht2();
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtColumns() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dhtColumns();
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dhtColumns();
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtRows() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dhtRows();
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.dhtRows();
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft2() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).fft2();
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.fft2();
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeDComplexMatrix2D getFft2() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getFft2();
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getFft2();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getIfft2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getIfft2(bl);
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getIfft2(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getFftColumns() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getFftColumns();
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getFftColumns();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getFftRows() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getFftRows();
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getFftRows();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getIfftColumns(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getIfftColumns(bl);
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getIfftColumns(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getIfftRows(boolean bl) {
        if (this.isNoView) {
            return ((DenseLargeDoubleMatrix2D)this.content).getIfftRows(bl);
        }
        return ((DenseLargeDoubleMatrix2D)this.copy()).getIfftRows(bl);
    }

    public void idct2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idct2(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idct2(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctColumns(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idctColumns(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idctColumns(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctRows(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idctRows(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idctRows(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idst2(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idst2(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstColumns(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idstColumns(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idstColumns(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstRows(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idstRows(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idstRows(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idht2(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idht2(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtColumns(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idhtColumns(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idhtColumns(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtRows(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idhtRows(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.idhtRows(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean bl) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).ifft2(bl);
            } else {
                DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = (DenseLargeDoubleMatrix2D)this.copy();
                denseLargeDoubleMatrix2D.ifft2(bl);
                this.assign(denseLargeDoubleMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized void setQuick(int n, int n2, double d) {
        this.content.setQuick(n, n2, d);
    }

    public DoubleMatrix1D vectorize() {
        final DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                final int n5 = i * n2 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n5;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperDoubleMatrix2D.this.rows; ++j) {
                                denseDoubleMatrix1D.setQuick(n++, WrapperDoubleMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseDoubleMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public DoubleMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, double d) {
                this.content.setQuick(n, this.columns - 1 - n2, d);
            }

            public synchronized double get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, double d) {
                this.content.set(n, this.columns - 1 - n2, d);
            }
        };
        wrapperDoubleMatrix2D.isNoView = false;
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewDice() {
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, double d) {
                this.content.setQuick(n2, n, d);
            }

            public synchronized double get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, double d) {
                this.content.set(n2, n, d);
            }
        };
        wrapperDoubleMatrix2D.rows = this.columns;
        wrapperDoubleMatrix2D.columns = this.rows;
        wrapperDoubleMatrix2D.isNoView = false;
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n3, int n22, double d) {
                this.content.setQuick(n + n3, n2 + n22, d);
            }

            public synchronized double get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n3, int n22, double d) {
                this.content.set(n + n3, n2 + n22, d);
            }
        };
        wrapperDoubleMatrix2D.rows = n3;
        wrapperDoubleMatrix2D.columns = n4;
        wrapperDoubleMatrix2D.isNoView = false;
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateDoubleMatrix1D(this, n);
    }

    public DoubleMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, double d) {
                this.content.setQuick(this.rows - 1 - n, n2, d);
            }

            public synchronized double get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, double d) {
                this.content.set(this.rows - 1 - n, n2, d);
            }
        };
        wrapperDoubleMatrix2D.isNoView = false;
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, double d) {
                this.content.setQuick(nArray3[n], nArray4[n2], d);
            }

            public synchronized double get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, double d) {
                this.content.set(nArray3[n], nArray4[n2], d);
            }
        };
        wrapperDoubleMatrix2D.rows = nArray.length;
        wrapperDoubleMatrix2D.columns = nArray2.length;
        wrapperDoubleMatrix2D.isNoView = false;
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n3, int n22, double d) {
                this.content.setQuick(n * n3, n2 * n22, d);
            }

            public synchronized double get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n3, int n22, double d) {
                this.content.set(n * n3, n2 * n22, d);
            }
        };
        if (this.rows != 0) {
            wrapperDoubleMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperDoubleMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperDoubleMatrix2D.isNoView = false;
        return wrapperDoubleMatrix2D;
    }

    protected DoubleMatrix2D getContent() {
        return this.content;
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

