/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatLUDecompositionQuick;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCMFloatMatrix2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FloatAMG
implements FloatPreconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private SparseRCFloatMatrix2D[] A;
    private DenseFloatLUDecompositionQuick lu;
    private DenseFloatMatrix1D[] u;
    private DenseFloatMatrix1D[] f;
    private DenseFloatMatrix1D[] r;
    private SparseCCFloatMatrix2D[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final float omegaPreF;
    private final float omegaPreR;
    private final float omegaPostF;
    private final float omegaPostR;
    private final boolean reverse;
    private final float omega;
    private boolean transpose;

    public FloatAMG(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, float f5) {
        this.omegaPreF = f;
        this.omegaPreR = f2;
        this.omegaPostF = f3;
        this.omegaPostR = f4;
        this.reverse = true;
        this.nu1 = n;
        this.nu2 = n2;
        this.gamma = n3;
        this.min = n4;
        this.omega = f5;
    }

    public FloatAMG(float f, float f2, int n, int n2, int n3, int n4, float f3) {
        this.omegaPreF = f;
        this.omegaPreR = f;
        this.omegaPostF = f2;
        this.omegaPostR = f2;
        this.reverse = false;
        this.nu1 = n;
        this.nu2 = n2;
        this.gamma = n3;
        this.min = n4;
        this.omega = f3;
    }

    public FloatAMG() {
        this(1.0f, 1.85f, 1.85f, 1.0f, 1, 1, 1, 40, 0.6666667f);
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.u[0].assign(floatMatrix1D2);
        this.f[0].assign(floatMatrix1D);
        this.transpose = false;
        this.cycle(0);
        return floatMatrix1D2.assign(this.u[0]);
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.u[0].assign(floatMatrix1D2);
        this.f[0].assign(floatMatrix1D);
        this.transpose = true;
        this.cycle(0);
        return floatMatrix1D2.assign(this.u[0]);
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        int n;
        float f;
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D;
        Aggregator aggregator;
        LinkedList<SparseRCFloatMatrix2D> linkedList = new LinkedList<SparseRCFloatMatrix2D>();
        LinkedList<SparseCCFloatMatrix2D> linkedList2 = new LinkedList<SparseCCFloatMatrix2D>();
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D2 = new SparseRCFloatMatrix2D(floatMatrix2D.rows(), floatMatrix2D.columns());
        sparseRCFloatMatrix2D2.assign(floatMatrix2D);
        if (!sparseRCFloatMatrix2D2.hasColumnIndexesSorted()) {
            sparseRCFloatMatrix2D2.sortColumnIndexes();
        }
        linkedList.add(sparseRCFloatMatrix2D2);
        int n2 = 0;
        while (((SparseRCFloatMatrix2D)linkedList.get(n2)).rows() > this.min && (aggregator = new Aggregator(sparseRCFloatMatrix2D = (SparseRCFloatMatrix2D)linkedList.get(n2), f = (float)(0.08 * Math.pow(0.5, n2)))).getAggregates().size() != 0) {
            Interpolator interpolator = new Interpolator(aggregator, sparseRCFloatMatrix2D, this.omega);
            linkedList.add(interpolator.getGalerkinOperator());
            linkedList2.add(interpolator.getInterpolationOperator());
            ++n2;
        }
        this.m = linkedList.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new SparseCCFloatMatrix2D[this.m - 1];
        this.A = new SparseRCFloatMatrix2D[this.m - 1];
        linkedList2.toArray(this.I);
        for (n2 = 0; n2 < linkedList.size() - 1; ++n2) {
            this.A[n2] = (SparseRCFloatMatrix2D)linkedList.get(n2);
        }
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(((SparseRCFloatMatrix2D)linkedList.get(linkedList.size() - 1)).toArray());
        this.lu = new DenseFloatLUDecompositionQuick();
        this.lu.decompose(denseFloatMatrix2D);
        this.u = new DenseFloatMatrix1D[this.m];
        this.f = new DenseFloatMatrix1D[this.m];
        this.r = new DenseFloatMatrix1D[this.m];
        for (n = 0; n < this.m; ++n) {
            int n3 = ((SparseRCFloatMatrix2D)linkedList.get(n)).rows();
            this.u[n] = new DenseFloatMatrix1D(n3);
            this.f[n] = new DenseFloatMatrix1D(n3);
            this.r[n] = new DenseFloatMatrix1D(n3);
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        for (n = 0; n < this.m - 1; ++n) {
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D3 = this.A[n];
            this.preM[n] = new SSOR(sparseRCFloatMatrix2D3, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[n] = new SSOR(sparseRCFloatMatrix2D3, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[n].setMatrix(sparseRCFloatMatrix2D3);
            this.postM[n].setMatrix(sparseRCFloatMatrix2D3);
        }
    }

    private void cycle(int n) {
        if (n == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(n);
            this.u[n + 1].assign(0.0f);
            this.A[n].zMult(this.u[n], this.r[n].assign(this.f[n]), -1.0f, 1.0f, false);
            this.I[n].zMult(this.r[n], this.f[n + 1], 1.0f, 0.0f, true);
            for (int i = 0; i < this.gamma; ++i) {
                this.cycle(n + 1);
            }
            this.I[n].zMult(this.u[n + 1], this.u[n], 1.0f, 1.0f, false);
            this.postRelax(n);
        }
    }

    private void directSolve() {
        int n = this.m - 1;
        this.u[n].assign(this.f[n]);
        if (this.transpose) {
            this.lu.setLU(this.lu.getLU().viewDice());
            this.lu.solve(this.u[n]);
            this.lu.setLU(this.lu.getLU().viewDice());
        } else {
            this.lu.solve(this.u[n]);
        }
    }

    private void preRelax(int n) {
        for (int i = 0; i < this.nu1; ++i) {
            if (this.transpose) {
                this.preM[n].transApply(this.f[n], this.u[n]);
                continue;
            }
            this.preM[n].apply(this.f[n], this.u[n]);
        }
    }

    private void postRelax(int n) {
        for (int i = 0; i < this.nu2; ++i) {
            if (this.transpose) {
                this.postM[n].transApply(this.f[n], this.u[n]);
                continue;
            }
            this.postM[n].apply(this.f[n], this.u[n]);
        }
    }

    private class SSOR
    implements FloatPreconditioner {
        private float omegaF;
        private float omegaR;
        private final SparseRCFloatMatrix2D F;
        private final int[] diagind;
        private final float[] xx;
        private final boolean reverse;

        public SSOR(SparseRCFloatMatrix2D sparseRCFloatMatrix2D, boolean bl, float f, float f2) {
            if (sparseRCFloatMatrix2D.rows() != sparseRCFloatMatrix2D.columns()) {
                throw new IllegalArgumentException("SSOR only applies to square matrices");
            }
            this.F = sparseRCFloatMatrix2D;
            this.reverse = bl;
            this.setOmega(f, f2);
            int n = sparseRCFloatMatrix2D.rows();
            this.diagind = new int[n];
            this.xx = new float[n];
        }

        public SSOR(SparseRCFloatMatrix2D sparseRCFloatMatrix2D) {
            this(sparseRCFloatMatrix2D, true, 1.0f, 1.0f);
        }

        public void setOmega(float f, float f2) {
            if (f < 0.0f || f > 2.0f) {
                throw new IllegalArgumentException("omegaF must be between 0 and 2");
            }
            if (f2 < 0.0f || f2 > 2.0f) {
                throw new IllegalArgumentException("omegaR must be between 0 and 2");
            }
            this.omegaF = f;
            this.omegaR = f2;
        }

        public void setMatrix(FloatMatrix2D floatMatrix2D) {
            this.F.assign(floatMatrix2D);
            int n = this.F.rows();
            int[] nArray = this.F.getRowPointers();
            int[] nArray2 = this.F.getColumnIndexes();
            for (int i = 0; i < n; ++i) {
                this.diagind[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1] - 1);
                if (this.diagind[i] >= 0) continue;
                throw new RuntimeException("Missing diagonal on row " + (i + 1));
            }
        }

        public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            int n;
            float f;
            int n2;
            if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
                throw new IllegalArgumentException("b and x must be a DenseFloatMatrix1D");
            }
            int[] nArray = this.F.getRowPointers();
            int[] nArray2 = this.F.getColumnIndexes();
            float[] fArray = this.F.getValues();
            float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D).elements();
            float[] fArray3 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
            int n3 = this.F.rows();
            System.arraycopy(fArray3, 0, this.xx, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                f = 0.0f;
                for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                    f += fArray[n] * this.xx[nArray2[n]];
                }
                for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                    f += fArray[n] * fArray3[nArray2[n]];
                }
                f = (fArray2[n2] - f) / fArray[this.diagind[n2]];
                this.xx[n2] = fArray3[n2] + this.omegaF * (f - fArray3[n2]);
            }
            if (!this.reverse) {
                System.arraycopy(this.xx, 0, fArray3, 0, n3);
                return floatMatrix1D2;
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                f = 0.0f;
                for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                    f += fArray[n] * this.xx[nArray2[n]];
                }
                for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                    f += fArray[n] * fArray3[nArray2[n]];
                }
                f = (fArray2[n2] - f) / fArray[this.diagind[n2]];
                fArray3[n2] = this.xx[n2] + this.omegaR * (f - this.xx[n2]);
            }
            floatMatrix1D2.assign(fArray3);
            return floatMatrix1D2;
        }

        public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return this.apply(floatMatrix1D, floatMatrix1D2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Interpolator {
        private SparseRCFloatMatrix2D Ac;
        private SparseCCFloatMatrix2D I;

        public Interpolator(Aggregator aggregator, SparseRCFloatMatrix2D sparseRCFloatMatrix2D, float f) {
            List<Set<Integer>> list = aggregator.getAggregates();
            List<Set<Integer>> list2 = aggregator.getNodeNeighborhoods();
            int[] nArray = aggregator.getDiagonalindexes();
            int[] nArray2 = this.createTentativeProlongation(list, sparseRCFloatMatrix2D.rows());
            if (f != 0.0f) {
                List<Map<Integer, Float>> list3 = this.createSmoothedProlongation(list, list2, sparseRCFloatMatrix2D, nArray, f, nArray2);
                this.I = this.createInterpolationMatrix(list3, sparseRCFloatMatrix2D.rows());
                this.Ac = this.createGalerkinSlow(this.I, sparseRCFloatMatrix2D);
            } else {
                this.Ac = this.createGalerkinFast(sparseRCFloatMatrix2D, nArray2, list.size());
                this.I = this.createInterpolationMatrix(nArray2, list.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> list, int n) {
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < list.size(); ++i) {
                for (int n2 : list.get(i)) {
                    nArray[n2] = i;
                }
            }
            return nArray;
        }

        private SparseRCFloatMatrix2D createGalerkinFast(SparseRCFloatMatrix2D sparseRCFloatMatrix2D, int[] nArray, int n) {
            int n2 = nArray.length;
            SparseRCMFloatMatrix2D sparseRCMFloatMatrix2D = new SparseRCMFloatMatrix2D(n, n);
            int[] nArray2 = sparseRCFloatMatrix2D.getRowPointers();
            int[] nArray3 = sparseRCFloatMatrix2D.getColumnIndexes();
            float[] fArray = sparseRCFloatMatrix2D.getValues();
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == -1) continue;
                for (int j = nArray2[i]; j < nArray2[i + 1]; ++j) {
                    if (nArray[nArray3[j]] == -1) continue;
                    sparseRCMFloatMatrix2D.setQuick(nArray[i], nArray[nArray3[j]], fArray[j]);
                }
            }
            return (SparseRCFloatMatrix2D)new SparseRCFloatMatrix2D(sparseRCMFloatMatrix2D.rows(), sparseRCMFloatMatrix2D.columns()).assign(sparseRCMFloatMatrix2D);
        }

        private SparseCCFloatMatrix2D createInterpolationMatrix(List<Map<Integer, Float>> list, int n) {
            int n2 = list.size();
            this.I = new SparseCCFloatMatrix2D(n, n2);
            for (int i = 0; i < n2; ++i) {
                Map<Integer, Float> map = list.get(i);
                for (Map.Entry<Integer, Float> entry : map.entrySet()) {
                    this.I.setQuick(entry.getKey(), i, entry.getValue().floatValue());
                }
            }
            return this.I;
        }

        private SparseCCFloatMatrix2D createInterpolationMatrix(int[] nArray, int n) {
            SparseCCMFloatMatrix2D sparseCCMFloatMatrix2D = new SparseCCMFloatMatrix2D(nArray.length, n);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                sparseCCMFloatMatrix2D.setQuick(i, nArray[i], 1.0f);
            }
            return (SparseCCFloatMatrix2D)new SparseCCFloatMatrix2D(sparseCCMFloatMatrix2D.rows(), sparseCCMFloatMatrix2D.columns()).assign(sparseCCMFloatMatrix2D);
        }

        public SparseCCFloatMatrix2D getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Float>> createSmoothedProlongation(List<Set<Integer>> list, List<Set<Integer>> list2, SparseRCFloatMatrix2D sparseRCFloatMatrix2D, int[] nArray, float f, int[] nArray2) {
            int n = sparseRCFloatMatrix2D.rows();
            int n2 = list.size();
            ArrayList<Map<Integer, Float>> arrayList = new ArrayList<Map<Integer, Float>>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new HashMap());
            }
            int[] nArray3 = sparseRCFloatMatrix2D.getRowPointers();
            int[] nArray4 = sparseRCFloatMatrix2D.getColumnIndexes();
            float[] fArray = sparseRCFloatMatrix2D.getValues();
            float[] fArray2 = new float[n2];
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == -1) continue;
                Arrays.fill(fArray2, 0.0f);
                Set<Integer> set = list2.get(i);
                float f2 = 0.0f;
                for (int j = nArray3[i]; j < nArray3[i + 1]; ++j) {
                    if (nArray2[nArray4[j]] == -1) continue;
                    float f3 = fArray[j];
                    if (f3 != 0.0f && !set.contains(nArray4[j])) {
                        f2 += f3;
                        continue;
                    }
                    int n3 = nArray2[nArray4[j]];
                    fArray2[n3] = fArray2[n3] + f3;
                }
                int n4 = nArray2[i];
                fArray2[n4] = fArray2[n4] - f2;
                float f4 = -f / fArray[nArray[i]];
                int n5 = 0;
                while (n5 < fArray2.length) {
                    int n6 = n5++;
                    fArray2[n6] = fArray2[n6] * f4;
                }
                int n7 = nArray2[i];
                fArray2[n7] = fArray2[n7] + 1.0f;
                for (n5 = 0; n5 < fArray2.length; ++n5) {
                    if (fArray2[n5] == 0.0f) continue;
                    ((Map)arrayList.get(n5)).put(i, Float.valueOf(fArray2[n5]));
                }
            }
            return arrayList;
        }

        private SparseRCFloatMatrix2D createGalerkinSlow(SparseCCFloatMatrix2D sparseCCFloatMatrix2D, SparseRCFloatMatrix2D sparseRCFloatMatrix2D) {
            int n = sparseCCFloatMatrix2D.rows();
            int n2 = sparseCCFloatMatrix2D.columns();
            SparseRCMFloatMatrix2D sparseRCMFloatMatrix2D = new SparseRCMFloatMatrix2D(n2, n2);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(n, fArray, 0, 1, false);
            DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(n, fArray2, 0, 1, false);
            float[] fArray3 = new float[n2];
            DenseFloatMatrix1D denseFloatMatrix1D3 = new DenseFloatMatrix1D(n2, fArray3, 0, 1, false);
            int[] nArray = sparseCCFloatMatrix2D.getColumnPointers();
            int[] nArray2 = sparseCCFloatMatrix2D.getRowIndexes();
            float[] fArray4 = sparseCCFloatMatrix2D.getValues();
            for (int i = 0; i < n2; ++i) {
                int n3;
                denseFloatMatrix1D2.assign(0.0f);
                for (n3 = nArray[i]; n3 < nArray[i + 1]; ++n3) {
                    fArray2[nArray2[n3]] = fArray4[n3];
                }
                sparseRCFloatMatrix2D.zMult(denseFloatMatrix1D2, denseFloatMatrix1D);
                sparseCCFloatMatrix2D.zMult(denseFloatMatrix1D, denseFloatMatrix1D3, 1.0f, 0.0f, true);
                for (n3 = 0; n3 < n2; ++n3) {
                    if (fArray3[n3] == 0.0f) continue;
                    sparseRCMFloatMatrix2D.setQuick(n3, i, fArray3[n3]);
                }
            }
            return (SparseRCFloatMatrix2D)new SparseRCFloatMatrix2D(sparseRCMFloatMatrix2D.rows(), sparseRCMFloatMatrix2D.columns()).assign(sparseRCMFloatMatrix2D);
        }

        public SparseRCFloatMatrix2D getGalerkinOperator() {
            return this.Ac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(SparseRCFloatMatrix2D sparseRCFloatMatrix2D, float f) {
            this.diagind = this.findDiagonalindexes(sparseRCFloatMatrix2D);
            this.N = this.findNodeNeighborhood(sparseRCFloatMatrix2D, this.diagind, f);
            boolean[] blArray = this.createInitialR(sparseRCFloatMatrix2D);
            this.C = this.createInitialAggregates(this.N, blArray);
            this.C = this.enlargeAggregates(this.C, this.N, blArray);
            this.C = this.createFinalAggregates(this.C, this.N, blArray);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalindexes() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalindexes(SparseRCFloatMatrix2D sparseRCFloatMatrix2D) {
            int[] nArray = sparseRCFloatMatrix2D.getRowPointers();
            int[] nArray2 = sparseRCFloatMatrix2D.getColumnIndexes();
            int[] nArray3 = new int[sparseRCFloatMatrix2D.rows()];
            for (int i = 0; i < sparseRCFloatMatrix2D.rows(); ++i) {
                nArray3[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1]);
                if (nArray3[i] >= 0) continue;
                throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
            }
            return nArray3;
        }

        private List<Set<Integer>> findNodeNeighborhood(SparseRCFloatMatrix2D sparseRCFloatMatrix2D, int[] nArray, float f) {
            this.N = new ArrayList<Set<Integer>>(sparseRCFloatMatrix2D.rows());
            int[] nArray2 = sparseRCFloatMatrix2D.getRowPointers();
            int[] nArray3 = sparseRCFloatMatrix2D.getColumnIndexes();
            float[] fArray = sparseRCFloatMatrix2D.getValues();
            for (int i = 0; i < sparseRCFloatMatrix2D.rows(); ++i) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                float f2 = fArray[nArray[i]];
                for (int j = nArray2[i]; j < nArray2[i + 1]; ++j) {
                    float f3 = fArray[j];
                    float f4 = fArray[nArray[nArray3[j]]];
                    if (!(Math.abs(f3) >= f * (float)Math.sqrt(f2 * f4))) continue;
                    hashSet.add(nArray3[j]);
                }
                this.N.add(hashSet);
            }
            return this.N;
        }

        private boolean[] createInitialR(SparseRCFloatMatrix2D sparseRCFloatMatrix2D) {
            boolean[] blArray = new boolean[sparseRCFloatMatrix2D.rows()];
            int[] nArray = sparseRCFloatMatrix2D.getRowPointers();
            int[] nArray2 = sparseRCFloatMatrix2D.getColumnIndexes();
            float[] fArray = sparseRCFloatMatrix2D.getValues();
            for (int i = 0; i < sparseRCFloatMatrix2D.rows(); ++i) {
                boolean bl = false;
                for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                    if (nArray2[j] == i || fArray[j] == 0.0f) continue;
                    bl = true;
                    break;
                }
                blArray[i] = bl;
            }
            return blArray;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> list, boolean[] blArray) {
            this.C = new ArrayList<Set<Integer>>();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                boolean bl = true;
                for (int n : list.get(i)) {
                    bl &= blArray[n];
                }
                if (!bl) continue;
                this.C.add(new HashSet(list.get(i)));
                for (int n : list.get(i)) {
                    blArray[n] = false;
                }
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> list, List<Set<Integer>> list2, boolean[] blArray) {
            int n;
            ArrayList arrayList = new ArrayList(blArray.length);
            for (n = 0; n < blArray.length; ++n) {
                arrayList.add(new ArrayList());
            }
            for (n = 0; n < list.size(); ++n) {
                for (int n2 : list.get(n)) {
                    ((List)arrayList.get(n2)).add(n);
                }
            }
            int[] nArray = new int[list.size()];
            for (int i = 0; i < blArray.length; ++i) {
                int n2;
                if (!blArray[i]) continue;
                Arrays.fill(nArray, 0);
                n2 = 0;
                int n3 = 0;
                for (int n4 : list2.get(i)) {
                    Iterator iterator = ((List)arrayList.get(n4)).iterator();
                    while (iterator.hasNext()) {
                        int n5;
                        int n6 = n5 = ((Integer)iterator.next()).intValue();
                        nArray[n6] = nArray[n6] + 1;
                        if (nArray[n5] <= n3) continue;
                        n2 = n5;
                        n3 = nArray[n2];
                    }
                }
                if (n3 <= 0) continue;
                blArray[i] = false;
                list.get(n2).add(i);
            }
            return list;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> list, List<Set<Integer>> list2, boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int n : list2.get(i)) {
                    if (!blArray[n]) continue;
                    blArray[n] = false;
                    hashSet.add(n);
                }
                if (hashSet.isEmpty()) continue;
                list.add(hashSet);
            }
            return list;
        }
    }
}

