/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.bin;

import cern.colt.buffer.tdouble.DoubleBuffer;
import cern.colt.buffer.tdouble.DoubleBufferConsumer;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.stat.tdouble.DoubleDescriptive;
import hep.aida.tdouble.bin.AbstractDoubleBin;

public abstract class AbstractDoubleBin1D
extends AbstractDoubleBin
implements DoubleBufferConsumer {
    private static final long serialVersionUID = 1L;

    protected AbstractDoubleBin1D() {
    }

    public abstract void add(double var1);

    public final synchronized void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.add(doubleArrayList.getQuick(i));
        }
    }

    public synchronized DoubleBuffer buffered(int n) {
        return new DoubleBuffer(this, n);
    }

    public String compareWith(AbstractDoubleBin1D abstractDoubleBin1D) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nDifferences [percent]");
        stringBuffer.append("\nSize: " + this.relError(this.size(), abstractDoubleBin1D.size()) + " %");
        stringBuffer.append("\nSum: " + this.relError(this.sum(), abstractDoubleBin1D.sum()) + " %");
        stringBuffer.append("\nSumOfSquares: " + this.relError(this.sumOfSquares(), abstractDoubleBin1D.sumOfSquares()) + " %");
        stringBuffer.append("\nMin: " + this.relError(this.min(), abstractDoubleBin1D.min()) + " %");
        stringBuffer.append("\nMax: " + this.relError(this.max(), abstractDoubleBin1D.max()) + " %");
        stringBuffer.append("\nMean: " + this.relError(this.mean(), abstractDoubleBin1D.mean()) + " %");
        stringBuffer.append("\nRMS: " + this.relError(this.rms(), abstractDoubleBin1D.rms()) + " %");
        stringBuffer.append("\nVariance: " + this.relError(this.variance(), abstractDoubleBin1D.variance()) + " %");
        stringBuffer.append("\nStandard deviation: " + this.relError(this.standardDeviation(), abstractDoubleBin1D.standardDeviation()) + " %");
        stringBuffer.append("\nStandard error: " + this.relError(this.standardError(), abstractDoubleBin1D.standardError()) + " %");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractDoubleBin1D)) {
            return false;
        }
        AbstractDoubleBin1D abstractDoubleBin1D = (AbstractDoubleBin1D)object;
        return this.size() == abstractDoubleBin1D.size() && this.min() == abstractDoubleBin1D.min() && this.max() == abstractDoubleBin1D.max() && this.sum() == abstractDoubleBin1D.sum() && this.sumOfSquares() == abstractDoubleBin1D.sumOfSquares();
    }

    public abstract double max();

    public synchronized double mean() {
        return this.sum() / (double)this.size();
    }

    public abstract double min();

    protected double relError(double d, double d2) {
        return 100.0 * (1.0 - d / d2);
    }

    public synchronized double rms() {
        return DoubleDescriptive.rms(this.size(), this.sumOfSquares());
    }

    public synchronized double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public synchronized double standardError() {
        return DoubleDescriptive.standardError(this.size(), this.variance());
    }

    public abstract double sum();

    public abstract double sumOfSquares();

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("\n-------------");
        stringBuffer.append("\nSize: " + this.size());
        stringBuffer.append("\nSum: " + this.sum());
        stringBuffer.append("\nSumOfSquares: " + this.sumOfSquares());
        stringBuffer.append("\nMin: " + this.min());
        stringBuffer.append("\nMax: " + this.max());
        stringBuffer.append("\nMean: " + this.mean());
        stringBuffer.append("\nRMS: " + this.rms());
        stringBuffer.append("\nVariance: " + this.variance());
        stringBuffer.append("\nStandard deviation: " + this.standardDeviation());
        stringBuffer.append("\nStandard error: " + this.standardError());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public synchronized void trimToSize() {
    }

    public synchronized double variance() {
        return DoubleDescriptive.sampleVariance(this.size(), this.sum(), this.sumOfSquares());
    }
}

