% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkIncidencePrevalence.R
\name{benchmarkIncidencePrevalence}
\alias{benchmarkIncidencePrevalence}
\title{Run benchmark of incidence and prevalence analyses}
\usage{
benchmarkIncidencePrevalence(
  cdm,
  returnParticipants = FALSE,
  analysisType = "all"
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{returnParticipants}{Whether to return participants}

\item{analysisType}{A string of the following: "all", "only incidence",
"only prevalence"}
}
\value{
a tibble with time taken for different analyses
}
\description{
Run benchmark of incidence and prevalence analyses
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(
  sampleSize = 100,
  earliestObservationStartDate = as.Date("2010-01-01"),
  latestObservationStartDate = as.Date("2010-01-01"),
  minDaysToObservationEnd = 364,
  maxDaysToObservationEnd = 364,
  outPre = 0.1
)

timings <- benchmarkIncidencePrevalence(cdm)
}
}
