% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotIncidence}
\alias{plotIncidence}
\title{Plot incidence results}
\usage{
plotIncidence(
  result,
  x = "incidence_start_date",
  y = "incidence_100000_pys",
  line = FALSE,
  point = TRUE,
  ribbon = FALSE,
  ymin = "incidence_100000_pys_95CI_lower",
  ymax = "incidence_100000_pys_95CI_upper",
  facet = NULL,
  colour = NULL
)
}
\arguments{
\item{result}{Incidence results}

\item{x}{Variable to plot on x axis}

\item{y}{Variable to plot on y axis.}

\item{line}{Whether to plot a line using \code{geom_line}}

\item{point}{Whether to plot points using \code{geom_point}}

\item{ribbon}{Whether to plot a ribbon using \code{geom_ribbon}}

\item{ymin}{Lower limit of error bars, if provided is plot using \code{geom_errorbar}}

\item{ymax}{Upper limit of error bars, if provided is plot using \code{geom_errorbar}}

\item{facet}{Variables to use for facets. To see available variables for
facetting use the function \code{availableIncidenceGrouping()}.}

\item{colour}{Variables to use for colours. To see available variables for
colouring use the function \code{availableIncidenceGrouping()}.}
}
\value{
A ggplot with the incidence results plotted
}
\description{
Plot incidence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
plotIncidence(inc)
}
}
