% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarity.R
\name{relativeDissimilarity}
\alias{relativeDissimilarity}
\title{Computes measures of relative dissimilarity between all periods}
\usage{
relativeDissimilarity(
  x,
  pvar,
  qvar,
  pervar,
  prodID,
  indexMethod = "fisher",
  similarityMethod = "logquadratic"
)
}
\arguments{
\item{x}{A dataframe containing price, quantities, a time
period index and a product identifier.}

\item{pvar}{A string identifying the price variable.}

\item{qvar}{A string identifying the quantity variable.}

\item{pervar}{A string identifying the time index variable.}

\item{prodID}{A string identifying the product ID.}

\item{indexMethod}{A string identifying the index method to
use in the calculation. Not relevant for similarityMethod = PLSpread.
Supported methods are fisher and tornqvist. Default is Fisher.}

\item{similarityMethod}{A string specifying the formula for calculating
the relative dissimilarity. Valid options are logquadratic, asymplinear
and PLSpread. Default is logquadratic.}
}
\value{
A matrix of dissimilarity measures.
The first two columns are the possible combinations of bilateral
comparisons and the third column is the dissimilarity measure.
}
\description{
A function to compute the relative price dissimilarity
between two vectors of prices.
}
\examples{
# estimate the dissimilarity between periods in the CES_sigma_2 dataset
# using the log quadratic measure of dissimilarity
relativeDissimilarity(CES_sigma_2, pvar = "prices", qvar="quantities",
pervar = "time", prodID = "prodID", indexMethod="fisher",
similarityMethod = "logquadratic")
}
\references{
Diewert, W.E. (2002). "Similarity and Dissimilarity Indexes:
An Axiomatic Approach" Discussion Paper No. 0210, Department of Economics,
University of British Columbia.
}
