% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarity.R
\name{maximumSimilarityLinks}
\alias{maximumSimilarityLinks}
\title{Finds periods to link using minimum dissimilarity.}
\usage{
maximumSimilarityLinks(x)
}
\arguments{
\item{x}{a matrix containing a dissimilarity measure where
the first two columns are the indices and the third column
is the dissimilarity measure.}
}
\description{
Function to compute the maximum similarity chain links from
a measure of dissimilarity. The procedure works as described in
Diewert and Fox (2017). It first links period 2 to period 1.
Then for each period t, from periods 3,...,T it searches
among the periods 1,...,t-1 for the period that is most
similar (least dissimilar) to period t.
}
\examples{
# find the linking periods in the CES_sigma_2 dataset that maximise
# the similarity between periods, using the absolute dissimilarity measure.
disMat <- mixScaleDissimilarity(CES_sigma_2, pvar = "prices", qvar = "quantities",
pervar = "time", prodID = "prodID", measure = "absolute",
combine = "geomean")
maximumSimilarityLinks(disMat)
}
