% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PiS.R
\name{PiS}
\alias{PiS}
\title{Matrix projection onto the nuclear norm unit sphere}
\usage{
PiS(M)
}
\arguments{
\item{M}{Input matrix}
}
\value{
A matrix of the same dimension as the input is returned.
}
\description{
Projection (with respect to the inner product defined by the Frobenius norm) of a matrix onto the unit sphere defined by the nuclear norm.
}
\details{
This is an auxiliary function used by the \code{InspectChangepoint} package. The projection is achieved by first performing a singular value decomposition, then projecting the vector of singular values onto the standard simplex, and finally using singular value decomposition in reverse to build the projected matrix.
}
\examples{
M <- matrix(rnorm(20),4,5)
PiS(M)
}
