% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{FindElement}
\alias{FindElement}
\title{Find an element in a data structure}
\usage{
FindElement(what = NULL, object = NULL, element = list())
}
\arguments{
\item{what}{A character string indicating which object to look for. Default is NULL.}

\item{object}{The data structure to look into. Only the classes data frame
and list are supported. Default is NULL.}

\item{element}{Not to be specified by the user.}
}
\value{
The returned value is a list with an element for each object found.
The element contains everything the object contained in the original data
structure.
}
\description{
The function \code{FindElement} is used internally in the
\code{PreparePathway} function but might come in handy for other uses as
well. Given the name of an object, the function searches for that object in
the data structure and extracts it. When multiple objects have the same
name, all are extracted.
}
\examples{

data(fingerprintMat)
data(targetMat)
data(geneMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

MCF7_DiffGenes_FandT10=DiffGenes(list(MCF7_F,MCF7_T),Selection=NULL,geneExpr=geneMat,
nrclusters=7,method="limma",sign=0.05,top=10,fusionsLog = TRUE, weightclust = TRUE, 
names = NULL)

Find=FindElement(what='TopDE',object=MCF7_DiffGenes_FandT10)
}
