% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-extract.R
\name{[}
\alias{[}
\alias{[,IntervalList-method}
\alias{[,IntervalMatrix-method}
\title{Extract parts of an interval-valued object}
\usage{
\S4method{[}{IntervalList}(x, i)
\S4method{[}{IntervalMatrix}(x, i, j)
}
\arguments{
\item{x}{interval-valued object from which to extract elements.}

\item{i}{indices specifying interval-valued list's elements or interval-valued matrix's rows to extract.}

\item{j}{indices specifying interval-valued matrix's columns to extract.}
}
\value{
Selected parts of an interval-valued object
}
\description{
Extract parts of interval-valued lists or matrices.
}
\examples{
list <- IntervalList(c(1,3,5), c(2, 4, 6))
list[1]
list[c(1, 3)]

m <- IntervalMatrix(matrix(c(1, 2, 6, 7, 3, 4, 5, 6, 2, 3, 4, 5), 2, 6, byrow = TRUE))
m[1,1]
m[1,]
m[, 1]
m[, c(1,3)]

}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
